package com.bizvane.rights.vo.evaluate;

import com.bizvane.rights.consts.BusinessConst;
import com.bizvane.rights.vo.PageVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class RightEvaluateRequestVO extends PageVO implements Serializable {



    @ApiModelProperty("评价类型订单类型:1:商业订单评价,2:停车服务评价,3:酒店预定评价,4:贵宾订单评价,5:机场管家评价," +
            "6:行李到门服务评价,7:无障碍车位服务预约,8:特殊旅客服务评价")
    private Integer evaluateType;

    @ApiModelProperty("订单/服务编号")
    private String orderNo;

    @ApiModelProperty("商户code")
    private String merchantCode;

    @ApiModelProperty("业态code")
    private String businessCode;


    @ApiModelProperty("会员卡号")
    private String memberCardNo;

    @ApiModelProperty("评价时间-开始")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime evaluateDateStart;

    @ApiModelProperty("评价时间-结束")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime evaluateDateEnd;




}
