package com.bizvane.rights.vo.hotel.order;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class RightsHotelOrderRefundRequestVO implements Serializable {

    @ApiModelProperty("退款id")
    private String refundId;
    @ApiModelProperty("外部退款交易号")
    private String outRefundNo;
    @ApiModelProperty("外部支付交易id")
    private String transactionId;
    @ApiModelProperty("外部支付交易号")
    private String outTradeNo;
    @ApiModelProperty("取当前退款单的退款入账方。\n1、退回银行卡：{银行名称}{卡类型}{卡尾号}\n2、退回支付用户零钱: 支付用户零钱\n3、退还商户: 商户基本账户、商户结算银行账户\n4、退回支付用户零钱通：支付用户零钱通\n5、退回用户经营账户：用户经营账户\n6、退回支付用户银行电子账户：支付用户银行电子账户\n7、退回支付用户零花钱：支付用户零花钱\n8、退回支付用户来华零钱包：支付用户来华零钱包\n9、退回企业支付商户：企业支付商户")
    private String userReceivedAccount;
    @ApiModelProperty("退款成功时间")
    private String successTime;
    @ApiModelProperty("退款创建时间")
    private String createTime;
    @ApiModelProperty("订单总金额，单位为元 保留两位小数。")
    private BigDecimal total;
    @ApiModelProperty("退款金额，单位为元 保留两位小数。")
    private BigDecimal refund;
    @ApiModelProperty("用户支付金额，单位为元 保留两位小数。")
    private BigDecimal payerTotal;
    @ApiModelProperty("用户退款金额，单位为元 保留两位小数。")
    private BigDecimal payerRefund;
    private String channel;
    private String fundsAccount;
    @ApiModelProperty("【退款状态】 退款状态：\nSUCCESS—退款成功\nCLOSED—退款关闭。\nPROCESSING—退款处理中\nABNORMAL—退款异常，退款到银行发现用户的卡作废或者冻结了，导致原路退款银行卡失败，可前往商户平台-交易中心，手动处理此笔退款，可参考： 退款异常的处理，或者通过发起异常退款接口进行处理。")
    private String status;
}
