package com.bizvane.rights.feign.mobile;

import com.bizvane.members.feign.model.vo.CouponEntityListResponseParam;
import com.bizvane.rights.vo.evaluate.EvaluateLabelResponseVO;
import com.bizvane.rights.vo.hotel.order.mobile.RightsHotelOrderPaymentRequestVO;
import com.bizvane.rights.vo.hotel.order.mobile.RightsHotelOrderPaymentResponseVO;
import com.bizvane.rights.vo.hotel.order.mobile.RightsHotelPreOrderRequestVO;
import com.bizvane.rights.vo.hotel.order.mobile.RightsHotelPreOrderResponseVO;
import com.bizvane.rights.vo.steward.*;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.validation.CreateValidation;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
@Api(value = "管家mobile记录", tags = "管家mobile记录")
@FeignClient(value = "${feign.client.rights.name}", path = "${feign.client.rights.path}/stewardMobile")
public interface StewardMobileFeign {

    @ApiOperation(value ="机场管家首页", notes = "机场管家首页", httpMethod = "POST")
    @PostMapping("/findStewardServiceDescription")
    public ResponseData<StewardServiceDescriptionMobileRespVo> findStewardServiceDescription();

    @ApiOperation(value ="根据航班号查询管家服务", notes = "根据航班号查询管家服务", httpMethod = "POST")
    @PostMapping("/findServiceByFlightIdentityAndDate")
    public ResponseData<StewardServiceByFlightIdentityAndDateMobileRespVo> findServiceByFlightIdentityAndDate(@RequestBody StewardServiceMobileReqVO reqVO);

    @ApiOperation(value ="立即预约", notes = "立即预约", httpMethod = "POST")
    @PostMapping("/payForOrder")
    public ResponseData<StewardPaymentRespVO> payForOrder(@RequestBody StewardPayForOrderMobileReqVO stewardOrderMobileReqVO);

    @ApiOperation(value ="立即支付后根据订单编码查结果", notes = "立即支付后根据订单编码查结果", httpMethod = "POST")
    @PostMapping("/findOrderDetailByOrderCode")
    public ResponseData<StewardOrderMobileRespVO> findOrderDetailByOrderCode(@RequestBody StewardOrderDetailMobileReqVo stewardOrderMobileReqVO);

    @ApiOperation(value ="取消订单", notes = "取消订单", httpMethod = "POST")
    @PostMapping("/cancel")
    public ResponseData<Boolean> cancel(@RequestBody StewardOrderCancelReq reqVO);

    @ApiOperation(value ="确认额外服务费用", notes = "确认额外服务费用", httpMethod = "POST")
    @PostMapping("/confirmAdditionalCost")
    public ResponseData<String> confirmAdditionalCost(@RequestBody StewardOrderConfirmAdditionalCostMobileReqVo stewardOrderMobileReqVO);

    @ApiOperation(value ="支付二维码", notes = "支付二维码", httpMethod = "POST")
    @PostMapping("/paymentOrCode")
    public ResponseData<String> paymentOrCode(@RequestBody StewardOrderPayReqVo stewardOrderVO);

    @ApiOperation(value ="管家订单", notes = "管家订单", httpMethod = "POST")
    @PostMapping("/findOrderList")
    public ResponseData<PageInfo<StewardOrderReqRespVO>> findOrderList(@RequestBody StewardOrderQueryMobileReqVo stewardOrderVO);

    @ApiOperation(value ="额外服务费用支付", notes = "额外服务费用支付", httpMethod = "POST")
    @PostMapping("/payAdditionalCost")
    public ResponseData<StewardPaymentRespVO> payAdditionalCost(@RequestBody StewardOrderMobileReqVO stewardOrderVO);

    @ApiOperation(value = "查询可用券列表", notes = "查询可用券列表", httpMethod = "POST")
    @PostMapping("listAvailable")
    ResponseData<PageInfo<CouponEntityListResponseParam>> listAvailable(@RequestBody StewardServiceMobileCouponRequestVO requestVO);

    @ApiOperation(value = "预下单", notes = "预下单", httpMethod = "POST")
    @PostMapping("preOrder")
    ResponseData<StewardServicePreOrderRespVo> preOrder(@RequestBody StewardServicePreOrderReqVo requestVO);

    @ApiOperation(value = "订单支付(微信)", notes = "订单支付", httpMethod = "POST")
    @PostMapping("orderPayment")
    ResponseData<StewardPaymentRespVO> orderPayment(@RequestBody StewardOrderPaymentRequeatVo requestVO);

    @ApiOperation(value = "修改订单状态", notes = "修改订单状态", httpMethod = "POST")
    @PostMapping("updateOrderStatus")
    ResponseData<Boolean> updateOrderStatus(@RequestBody StewardOrderStatusReqVO requestVO);

    @ApiOperation(value = "获取额外服务支付结果", notes = "获取额外服务支付结果", httpMethod = "POST")
    @PostMapping("selectPayAdditionalCostStatus")
    ResponseData<Boolean> selectPayAdditionalCostStatus(@RequestBody StewardOrderStatusReqVO reqVO);
}
