package com.bizvane.rights.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

@AllArgsConstructor
@Getter
public enum HotelOrderReservationTypeEnum {

    EMPLOYEE_RESERVATION(1, "员工预定"),
    MEMBER_RESERVATION(2, "会员预定")

    ;
    private Integer type;

    private String desc;

    public static HotelOrderReservationTypeEnum fromType(Integer type) {
        for (HotelOrderReservationTypeEnum hotelOrderReservationTypeEnum : HotelOrderReservationTypeEnum.values()) {
            if (hotelOrderReservationTypeEnum.getType().equals(type)) {
                return hotelOrderReservationTypeEnum;
            }
        }
        return null;
    }
}
