package com.bizvane.rights.vo.staffbenefit;

import com.bizvane.rights.consts.BusinessConst;
import com.bizvane.rights.vo.OptUserVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

@Data
public class QueryStaffBenefitDetailRespVO extends OptUserVO {

    @ApiModelProperty("员工福利系统code")
    private String mktStaffBenefitCode;

    @ApiModelProperty("关联员工福利类型系统code")
    private String mktStaffBenefitTypeCode;

    @ApiModelProperty("福利名称")
    private String benefitName;

    @ApiModelProperty("投放开始时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime openStartTime;

    @ApiModelProperty("投放结束时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime openEndTime;

    @ApiModelProperty("是否长期：1是，0否")
    private Integer longTerm;

    @ApiModelProperty("活动开始时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime startTime;

    @ApiModelProperty("活动结束时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime endTime;

    @ApiModelProperty("活动封面图")
    private String activityBgi;

    @ApiModelProperty("福利形式类型 0线上展示 1链接跳转")
    private Integer showType;

    @ApiModelProperty("链接跳转url")
    private String clickUrl;

    @ApiModelProperty("0=文字   1=图片")
    private Integer activityDescType;

    @ApiModelProperty("活动描述、简介")
    private String activityDesc;

    @ApiModelProperty("活动详情图片")
    private String activityDescImg;

    @ApiModelProperty("活动图片，多张逗号分隔")
    private String activityImg;

    @ApiModelProperty(value = "排序")
    private Integer sort;

    @ApiModelProperty(value = "状态 0待上架 1上架中 2已下架 3已结束 4已禁用")
    private Integer state;

    @ApiModelProperty(value = "审核状态：1待审核，2审核中，3已审核，4已驳回， 5审核关闭")
    private Integer checkStatus;

    @ApiModelProperty(value = "审核备注")
    private String checkRemark;

    @ApiModelProperty(value = "审核人code")
    private String checkUserCode;

    @ApiModelProperty(value = "审核人名称")
    private String checkUserName;

    @ApiModelProperty("启用状态 0禁用1启用")
    private Integer enableStatus;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime createDate;

    @ApiModelProperty("创建人名称")
    private String createUserName;

    @ApiModelProperty("更新时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime modifiedDate;

    @ApiModelProperty("更新人名称")
    private String modifiedUserName;
}
