package com.bizvane.rights.vo.steward;

import com.bizvane.utils.validation.CreateValidation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author liuying
 * @since 2024-12-09
 */
@Data
@ApiModel(value = "StewardOrderMobile请求对象", description = "")
public class StewardOrderMobileReqVO implements Serializable {

    @ApiModelProperty("航班号")
    private String flightIdentity;

    @ApiModelProperty("航班日期")
    private String flightScheduledDate;

    @ApiModelProperty("联系方式")
    private String mbrPhone;

    @ApiModelProperty("所选择的管家服务编码,多个用逗号分隔")
    private String stewardServiceCode;

    @ApiModelProperty("订单编码,点立即支付才生成")
    private String stewardOrderCode;

    @ApiModelProperty("订单支付金额，页面传入")
    private BigDecimal reservePrice;

    @ApiModelProperty("更改订单状态")
    private Integer status;

    @ApiModelProperty("用户openid")
    private String mbrOpenid;

}
