package com.bizvane.rights.vo.steward;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 
 * </p>
 *
 * @author liuying
 * @since 2024-12-09
 */
@Getter
@Setter
@ApiModel(value = "StewardOrderMobile响应对象", description = "")
public class StewardOrderMobileRespVO implements Serializable {
    @ApiModelProperty("机场管家订单code")
    private String stewardOrderCode;
    @ApiModelProperty("订单下对应的管家服务信息")
    List<StewardServiceReqRespVO> services;
    @ApiModelProperty("订单二维码")
    private String orderQRCode;
    @ApiModelProperty("支付时间")
    private String paymentDate;
    @ApiModelProperty("完成时间")
    private String finishDate;
    @ApiModelProperty("下单时间")
    private LocalDateTime createDate;
    @ApiModelProperty("航班信息code")
    private String basicFlightCode;
    @ApiModelProperty("航班日期")
    private LocalDateTime flightScheduledDate;
    @ApiModelProperty("航班号")
    private String flightIdentity;
    @ApiModelProperty("航空公司名称")
    private String airlineCn;
    @ApiModelProperty("起飞机场")
    private String cnOriginAirport;
    @ApiModelProperty("到达机场")
    private String cnDestinationAirport;
    @ApiModelProperty("关联 t_basic_dict_general")
    private String orderServiceType;
    @ApiModelProperty("服务名称(接机服务，送机服务)")
    private String orderServiceName;
    @ApiModelProperty("预订价格")
    private BigDecimal reservePrice;

}
