package com.bizvane.rights.vo.hotel.order.mobile;

import com.bizvane.rights.consts.BusinessConst;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

@Data
public class RightsHotelOrderDetailResponseVO extends RightsHotelPreOrderResponseVO implements Serializable {

    @ApiModelProperty("预定姓名")
    private String reservationName;

    @ApiModelProperty(value = "预定手机号",example = "177****2222")
    private String reservationPhone;

    @ApiModelProperty(value = "预计到店时间",example = "12:00")
    @JsonFormat(pattern = BusinessConst.HM, timezone = BusinessConst.TIMEZONE)
    private LocalTime expectedArrivalTime;

    @ApiModelProperty(value = "支付状态 1.入住时支付 2.微信支付",example = "1")
    private Integer payType;

    @ApiModelProperty("酒店订单code")
    private String rightsHotelOrderCode;

    @ApiModelProperty(value = "订单状态 1.待确认 2.已确认 3.已入住 4.已取消 5.待支付 6.退款中", example = "1")
    private Integer orderStatus;

    @ApiModelProperty("处理说明")
    private String handlingInstructions;

    @ApiModelProperty("房型名称")
    private String roomTypeName;

    @ApiModelProperty("房型面积")
    private String roomArea;

    @ApiModelProperty("床型信息")
    private String bedType;

    @ApiModelProperty("支付截止时间(秒)")
    private long paymentDeadlineSeconds;

    @ApiModelProperty("支付截止时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime paymentDeadline;
}
