/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.service.impl;

import cn.hutool.core.util.NumberUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.members.feign.model.bo.CouponEntityRevertRequestParam;
import com.bizvane.members.feign.service.CouponFeign;
import com.bizvane.payment.feign.api.ApiWechatRefundFeign;
import com.bizvane.payment.feign.vo.req.RefundOrderReqVO;
import com.bizvane.rights.api.service.EvaluateService;
import com.bizvane.rights.api.service.component.OrderComponent;
import com.bizvane.rights.api.service.component.PaymentComponent;
import com.bizvane.rights.domain.consts.StewardOrderConst;
import com.bizvane.rights.domain.enums.StewardOrderStatusEnum;
import com.bizvane.rights.domain.enums.StewardStatusEnum;
import com.bizvane.rights.domain.model.entity.StewardOrderPO;
import com.bizvane.rights.domain.service.IStewardOrderService;
import com.bizvane.rights.domain.util.AssertUtil;
import com.bizvane.rights.domain.util.ResponseUtil;
import com.bizvane.rights.enums.EvaluateLabelTypeEnum;
import com.bizvane.rights.vo.evaluate.RightEvaluateRequestVO;
import com.bizvane.rights.vo.evaluate.RightEvaluateResponseVO;
import com.bizvane.rights.vo.hotel.order.RightsHotelOrderRefundRequestVO;
import com.bizvane.rights.vo.hotel.order.RightsStewardOrderRefundResponseVO;
import com.bizvane.rights.vo.steward.StewardOperateOrdersRequestVO;
import com.bizvane.rights.vo.steward.StewardOperateOrdersResponseVO;
import com.bizvane.rights.vo.steward.StewardOrderQueryReqVO;
import com.bizvane.rights.vo.steward.StewardOrderReqRespVO;
import com.bizvane.rights.vo.steward.StewardOrderStatisticsResponseVo;
import com.bizvane.rights.vo.steward.StewardOrderWithEvaluateRequestVO;
import com.bizvane.rights.vo.steward.StewardOrderWithEvaluateResponseVO;
import com.bizvane.utils.enumutils.ValidEnum;
import com.bizvane.utils.exception.BizException;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StewardOrderService {
    private static final Logger log = LoggerFactory.getLogger(StewardOrderService.class);
    @Autowired
    private final IStewardOrderService stewardOrderService;
    private final EvaluateService evaluateService;
    @Autowired
    private CouponFeign couponFeign;
    @Autowired
    private ApiWechatRefundFeign refundFeign;
    @Autowired
    private PaymentComponent paymentComponent;
    @Autowired
    private OrderComponent orderComponent;

    public ResponseData<PageInfo<StewardOrderReqRespVO>> pageList(StewardOrderQueryReqVO stewardOrderQueryVO) {
        Page page = new Page((long)stewardOrderQueryVO.getPageNum().intValue(), (long)stewardOrderQueryVO.getPageSize().intValue());
        LambdaQueryWrapper wrapperr = new LambdaQueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)stewardOrderQueryVO.getOrderNo())) {
            wrapperr.eq(StewardOrderPO::getOrderNo, (Object)stewardOrderQueryVO.getOrderNo());
        }
        if (null != stewardOrderQueryVO.getStatus()) {
            wrapperr.eq(StewardOrderPO::getStatus, (Object)stewardOrderQueryVO.getStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)stewardOrderQueryVO.getOrderServiceName())) {
            wrapperr.eq(StewardOrderPO::getOrderServiceName, (Object)stewardOrderQueryVO.getOrderServiceName());
        }
        if (StringUtils.isNotBlank((CharSequence)stewardOrderQueryVO.getMbrName())) {
            wrapperr.eq(StewardOrderPO::getMbrName, (Object)stewardOrderQueryVO.getMbrName());
        }
        if (StringUtils.isNotBlank((CharSequence)stewardOrderQueryVO.getStaffCode())) {
            wrapperr.eq(StewardOrderPO::getStaffName, (Object)stewardOrderQueryVO.getStaffName());
        }
        if (stewardOrderQueryVO.getReservationTimeStart() != null && stewardOrderQueryVO.getReservationTimeEnd() != null) {
            wrapperr.between(StewardOrderPO::getReservationTime, (Object)stewardOrderQueryVO.getReservationTimeStart(), (Object)stewardOrderQueryVO.getReservationTimeEnd());
        }
        wrapperr.orderByDesc(StewardOrderPO::getCreateDate);
        wrapperr.eq(StewardOrderPO::getValid, (Object)Boolean.TRUE);
        Page stewardOrderPOPage = (Page)this.stewardOrderService.page((IPage)page, (Wrapper)wrapperr);
        List stewardOrderReqRespVOList = stewardOrderPOPage.getRecords().stream().map(po -> {
            StewardOrderReqRespVO stewardOrderReqRespVO = this.buildStewardOrderReqRespVO(po);
            return stewardOrderReqRespVO;
        }).collect(Collectors.toList());
        PageInfo pageInfo = new PageInfo(Long.valueOf(stewardOrderPOPage.getCurrent()).intValue(), Long.valueOf(stewardOrderPOPage.getSize()).intValue(), stewardOrderPOPage.getTotal(), stewardOrderReqRespVOList);
        return ResponseUtil.success((Object)pageInfo);
    }

    private StewardOrderReqRespVO buildStewardOrderReqRespVO(StewardOrderPO stewardOrderPO) {
        StewardOrderReqRespVO stewardOrderReqRespVO = new StewardOrderReqRespVO();
        BeanUtils.copyProperties((Object)stewardOrderPO, (Object)stewardOrderReqRespVO);
        return stewardOrderReqRespVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<StewardOperateOrdersResponseVO> processingConfirm(StewardOperateOrdersRequestVO requestVO) {
        StewardOrderPO one = this.getStewardOrderByCode(requestVO.getStewardOrderCode());
        if (null == one) {
            return ResponseUtil.fail((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (one.getStatus().compareTo(StewardOrderStatusEnum.TO_BE_CONFIRMED.getOrderStatus()) != 0) {
            return ResponseUtil.fail((String)"\u8ba2\u5355\u5df2\u786e\u8ba4");
        }
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(StewardOrderPO::getStaffCode, (Object)requestVO.getStaffCode())).set(StewardOrderPO::getStaffName, (Object)requestVO.getStaffName())).set(StewardOrderPO::getModifiedUserCode, (Object)requestVO.getOptUserCode())).set(StewardOrderPO::getModifiedUserName, (Object)requestVO.getOptUserName())).set(StringUtils.isNotBlank((CharSequence)requestVO.getRefundInstructions()), StewardOrderPO::getRefundInstructions, (Object)requestVO.getRefundInstructions())).eq(StewardOrderPO::getStewardOrderCode, (Object)requestVO.getStewardOrderCode())).eq(StewardOrderPO::getStatus, (Object)StewardOrderStatusEnum.TO_BE_CONFIRMED.getOrderStatus());
        if (StewardOrderConst.OPERATE_CHECK_IN.compareTo(requestVO.getOperate()) == 0) {
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.set(StewardOrderPO::getStatus, (Object)StewardOrderStatusEnum.AFFIRM.getOrderStatus())).set(StewardOrderPO::getConfirmTime, (Object)LocalDateTime.now())).set(StewardOrderPO::getConfirmerUserCode, (Object)requestVO.getOptUserCode())).set(StewardOrderPO::getConfirmerUserName, (Object)requestVO.getOptUserName());
            boolean update = this.stewardOrderService.update((Wrapper)updateWrapper);
            StewardOperateOrdersResponseVO responseVO = new StewardOperateOrdersResponseVO();
            responseVO.setOptStatus(update);
            return ResponseUtil.success((Object)responseVO);
        }
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.set(StewardOrderPO::getStatus, (Object)StewardOrderStatusEnum.CANCELLED.getOrderStatus())).set(StewardOrderPO::getCancellationTime, (Object)LocalDateTime.now())).set(StewardOrderPO::getCancellationUserCode, (Object)requestVO.getOptUserCode())).set(StewardOrderPO::getCancelType, (Object)StewardStatusEnum.BACKGROUND_CANCEL.getStatus())).set(StewardOrderPO::getCancellationUserCode, (Object)requestVO.getOptUserCode())).set(StewardOrderPO::getRefundStatus, (Object)StewardStatusEnum.REFUND_PROCESSING.getStatus())).set(StewardOrderPO::getCancellationUserName, (Object)requestVO.getOptUserName());
        boolean update = this.stewardOrderService.update((Wrapper)updateWrapper);
        if (update) {
            if (NumberUtil.isGreater((BigDecimal)one.getReallyPrice(), (BigDecimal)BigDecimal.ZERO)) {
                RefundOrderReqVO refundOrderReqVO = new RefundOrderReqVO();
                refundOrderReqVO.setOrderAmount(one.getReallyPrice());
                refundOrderReqVO.setRefundAmount(one.getRefundAmount());
                this.wechatRefund(one, refundOrderReqVO);
            } else {
                log.info("\u8ba2\u5355\u91d1\u989d0\u5143\uff0c\u65e0\u9700\u9000\u6b3e,\u53ea\u9000\u5238");
                if (StringUtils.isNotBlank((CharSequence)one.getCouponCode())) {
                    this.revertCounpon(one);
                }
            }
        }
        StewardOperateOrdersResponseVO responseVO = new StewardOperateOrdersResponseVO();
        responseVO.setOptStatus(update);
        return ResponseUtil.success((Object)responseVO);
    }

    private void wechatRefund(StewardOrderPO one, RefundOrderReqVO refundOrderReqVO) {
        refundOrderReqVO.setOutTradeNo(one.getOrderNo());
        refundOrderReqVO.setOutRefundNo(one.getStewardOrderCode());
        refundOrderReqVO.setChannelType("stewardOrder");
        ResponseData responseData = this.paymentComponent.refund(refundOrderReqVO);
        AssertUtil.judge((Boolean)ResponseUtil.isSuccess((ResponseData)responseData), (String)String.format("\u673a\u573a\u7ba1\u5bb6\u8ba2\u5355:%s\u53d1\u8d77\u9000\u6b3e\u5931\u8d25", one.getOrderNo()));
    }

    private ResponseData<Object> revertCounpon(StewardOrderPO one) {
        String couponCode = one.getCouponCode();
        CouponEntityRevertRequestParam param = new CouponEntityRevertRequestParam();
        param.setCouponNo(couponCode);
        param.setMbrMembersCode(one.getMbrMembersCode());
        param.setRevertTime(LocalDateTime.now());
        ResponseData revert = this.couponFeign.revert(param);
        return ResponseUtil.success((Object)revert);
    }

    public ResponseData<StewardOperateOrdersResponseVO> orderReassignment(StewardOperateOrdersRequestVO requestVO) {
        StewardOrderPO one = this.getStewardOrderByCode(requestVO.getStewardOrderCode());
        if (null == one) {
            return ResponseUtil.fail((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (StewardOrderStatusEnum.CONFIRMED.getOrderStatus() != one.getStatus() && StewardOrderStatusEnum.AFFIRM.getOrderStatus() != one.getStatus()) {
            return ResponseUtil.fail((String)"\u65e0\u6cd5\u6539\u6d3e");
        }
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(StewardOrderPO::getStaffCode, (Object)requestVO.getStaffCode())).set(StewardOrderPO::getStaffName, (Object)requestVO.getStaffName())).eq(StewardOrderPO::getStewardOrderCode, (Object)requestVO.getStewardOrderCode());
        boolean update = this.stewardOrderService.update((Wrapper)updateWrapper);
        StewardOperateOrdersResponseVO responseVO = new StewardOperateOrdersResponseVO();
        responseVO.setOptStatus(update);
        return ResponseUtil.success((Object)responseVO);
    }

    private StewardOrderPO getStewardOrderByCode(String code) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(StewardOrderPO::getStewardOrderCode, (Object)code)).eq(StewardOrderPO::getValid, (Object)ValidEnum.VALID.getCode())).last("limit 1");
        StewardOrderPO one = (StewardOrderPO)this.stewardOrderService.getOne((Wrapper)queryWrapper);
        return one;
    }

    public ResponseData<StewardOperateOrdersResponseVO> orderCancellation(StewardOperateOrdersRequestVO requestVO) {
        StewardOrderPO stewardOrderPO = this.getStewardOrderByCode(requestVO.getStewardOrderCode());
        if (null == stewardOrderPO) {
            return ResponseUtil.fail((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (StewardOrderStatusEnum.CANCELLED.getOrderStatus() == stewardOrderPO.getStatus()) {
            return ResponseUtil.fail((String)"\u8ba2\u5355\u5df2\u53d6\u6d88");
        }
        if (StewardOrderStatusEnum.CHECKED_IN.getOrderStatus() == stewardOrderPO.getStatus()) {
            return ResponseUtil.fail((String)"\u8ba2\u5355\u5df2\u5b8c\u6210\uff0c\u65e0\u6cd5\u53d6\u6d88");
        }
        if (stewardOrderPO.getReallyPrice().compareTo(requestVO.getRefundAmount()) < 0) {
            return ResponseUtil.fail((String)"\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5b9e\u4ed8\u91d1\u989d");
        }
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(StewardOrderPO::getStatus, (Object)StewardOrderStatusEnum.CANCELLED.getOrderStatus())).set(StewardOrderPO::getCancelType, (Object)StewardStatusEnum.BACKGROUND_CANCEL.getStatus())).set(StewardOrderPO::getRefundStatus, (Object)StewardStatusEnum.REFUND_PROCESSING.getStatus())).set(StewardOrderPO::getCancellationTime, (Object)LocalDateTime.now())).set(StewardOrderPO::getCancellationUserCode, (Object)requestVO.getOptUserCode())).set(StewardOrderPO::getCancellationUserName, (Object)requestVO.getOptUserName())).set(StewardOrderPO::getRefundAmount, (Object)requestVO.getRefundAmount())).set(StewardOrderPO::getRefundCoupon, (Object)requestVO.getRefundCoupon())).set(StewardOrderPO::getRefundInstructions, (Object)requestVO.getRefundInstructions())).eq(StewardOrderPO::getStewardOrderCode, (Object)requestVO.getStewardOrderCode())).in(StewardOrderPO::getStatus, Arrays.asList(StewardOrderStatusEnum.CONFIRMED.getOrderStatus(), StewardOrderStatusEnum.AFFIRM.getOrderStatus()));
        boolean update = this.stewardOrderService.update((Wrapper)updateWrapper);
        if (update) {
            RefundOrderReqVO refundOrderReqVO = new RefundOrderReqVO();
            refundOrderReqVO.setRefundAmount(requestVO.getRefundAmount());
            refundOrderReqVO.setOrderAmount(stewardOrderPO.getReallyPrice());
            this.wechatRefund(stewardOrderPO, refundOrderReqVO);
        }
        StewardOperateOrdersResponseVO responseVO = new StewardOperateOrdersResponseVO();
        responseVO.setOptStatus(update);
        return ResponseUtil.success((Object)responseVO);
    }

    public ResponseData<StewardOrderWithEvaluateResponseVO> orderEvaluation(StewardOrderWithEvaluateRequestVO requestVO) {
        StewardOrderPO stewardOrderPO = this.stewardOrderService.stewardOrderByOrderNo(requestVO.getOrderNo());
        StewardOrderWithEvaluateResponseVO stewardOrderWithEvaluateResponseVO = this.buildStewardOrderWithEvaluateResponseVO(stewardOrderPO);
        if (stewardOrderPO != null) {
            RightEvaluateRequestVO evaluateRequestVO = new RightEvaluateRequestVO();
            evaluateRequestVO.setEvaluateType(EvaluateLabelTypeEnum.AIRPORT_GUARD.getCode());
            evaluateRequestVO.setOrderNo(stewardOrderPO.getOrderNo());
            ResponseData rightEvaluateResponseVOResponseData = this.evaluateService.detailByTypeAndOrderNo(evaluateRequestVO);
            RightEvaluateResponseVO rightEvaluateResponseVO = (RightEvaluateResponseVO)rightEvaluateResponseVOResponseData.getData();
            stewardOrderWithEvaluateResponseVO.setEvaluate(rightEvaluateResponseVO);
        }
        return ResponseUtil.success((Object)stewardOrderWithEvaluateResponseVO);
    }

    private StewardOrderWithEvaluateResponseVO buildStewardOrderWithEvaluateResponseVO(StewardOrderPO stewardOrderPO) {
        StewardOrderWithEvaluateResponseVO stewardOrderWithEvaluateResponseVO = new StewardOrderWithEvaluateResponseVO();
        BeanUtils.copyProperties((Object)stewardOrderPO, (Object)stewardOrderWithEvaluateResponseVO);
        return stewardOrderWithEvaluateResponseVO;
    }

    public ResponseData<StewardOrderStatisticsResponseVo> statistics() {
        StewardOrderStatisticsResponseVo stewardOrderStatisticsResponseVo = new StewardOrderStatisticsResponseVo();
        long toBeConfirmed = this.stewardOrderService.countByStatus(StewardOrderStatusEnum.TO_BE_CONFIRMED.getOrderStatus());
        long confirmed = this.stewardOrderService.countByStatus(StewardOrderStatusEnum.CONFIRMED.getOrderStatus());
        long completed = this.stewardOrderService.countByStatus(StewardOrderStatusEnum.CHECKED_IN.getOrderStatus());
        long cancelled = this.stewardOrderService.countByStatus(StewardOrderStatusEnum.CANCELLED.getOrderStatus());
        long affirmed = this.stewardOrderService.countByStatus(StewardOrderStatusEnum.AFFIRM.getOrderStatus());
        long all = toBeConfirmed + confirmed + completed + cancelled;
        stewardOrderStatisticsResponseVo.setAll(Long.valueOf(all));
        stewardOrderStatisticsResponseVo.setToBeConfirmed(Long.valueOf(toBeConfirmed));
        stewardOrderStatisticsResponseVo.setConfirmed(Long.valueOf(confirmed));
        stewardOrderStatisticsResponseVo.setCompleted(Long.valueOf(completed));
        stewardOrderStatisticsResponseVo.setCancelled(Long.valueOf(cancelled));
        stewardOrderStatisticsResponseVo.setAffirmed(Long.valueOf(affirmed));
        return ResponseUtil.success((Object)stewardOrderStatisticsResponseVo);
    }

    public StewardOrderReqRespVO detailByCode(String stewardOrderCode) {
        StewardOrderReqRespVO reqRespVO = this.stewardOrderService.detailByCode(stewardOrderCode);
        return reqRespVO;
    }

    public ResponseData<RightsStewardOrderRefundResponseVO> refundCallback(RightsHotelOrderRefundRequestVO requestVO) {
        StewardOrderPO stewardOrderPO = this.stewardOrderService.getByOrderNo(requestVO.getOutTradeNo());
        AssertUtil.notNull((Object)stewardOrderPO, (String)"\u6b64\u673a\u573a\u7ba1\u5bb6\u8ba2\u5355\u4e0d\u5b58\u5728");
        String status = requestVO.getStatus();
        if ("SUCCESS".equalsIgnoreCase(status)) {
            return this.refundSuccess(stewardOrderPO, requestVO);
        }
        if (Arrays.asList("CLOSED", "PROCESSING").contains(status)) {
            return ResponseUtil.success((Object)new RightsStewardOrderRefundResponseVO(), (String)"\u9000\u6b3e\u5173\u95ed,\u9000\u6b3e\u4e2d\u72b6\u6001\u4e0d\u5904\u7406");
        }
        if ("ABNORMAL".equalsIgnoreCase(status)) {
            return this.refundFail(stewardOrderPO);
        }
        throw new BizException("\u672a\u77e5\u7684\u9000\u6b3e\u72b6\u6001,\u4e0d\u5904\u7406");
    }

    private ResponseData<RightsStewardOrderRefundResponseVO> refundFail(StewardOrderPO stewardOrderPO) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.set(StewardOrderPO::getRefundStatus, (Object)StewardStatusEnum.REFUND_FAIL.getStatus())).eq(StewardOrderPO::getStewardOrderCode, (Object)stewardOrderPO.getStewardOrderCode())).eq(StewardOrderPO::getRefundStatus, (Object)StewardStatusEnum.REFUND_PROCESSING.getStatus())).eq(StewardOrderPO::getStatus, (Object)StewardOrderStatusEnum.CANCELLED.getOrderStatus());
        boolean update = this.stewardOrderService.update((Wrapper)updateWrapper);
        RightsStewardOrderRefundResponseVO responseVO = new RightsStewardOrderRefundResponseVO();
        responseVO.setOptStatus(update);
        return ResponseUtil.success((Object)responseVO);
    }

    private ResponseData<RightsStewardOrderRefundResponseVO> refundSuccess(StewardOrderPO stewardOrderPO, RightsHotelOrderRefundRequestVO requestVO) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.set(StewardOrderPO::getRefundStatus, (Object)StewardStatusEnum.REFUND_SUCCESS.getStatus())).set(StewardOrderPO::getRefundOrderTradeRecordCode, (Object)requestVO.getOutRefundNo())).set(StewardOrderPO::getRefundTransactionId, (Object)requestVO.getRefundId())).set(StewardOrderPO::getRefundAmount, (Object)requestVO.getRefund())).eq(StewardOrderPO::getStewardOrderCode, (Object)stewardOrderPO.getStewardOrderCode())).eq(StewardOrderPO::getRefundStatus, (Object)StewardStatusEnum.REFUND_PROCESSING.getStatus())).eq(StewardOrderPO::getStatus, (Object)StewardOrderStatusEnum.CANCELLED.getOrderStatus());
        boolean update = this.stewardOrderService.update((Wrapper)updateWrapper);
        Integer refundCoupon = stewardOrderPO.getRefundCoupon();
        if (StringUtils.isBlank((CharSequence)stewardOrderPO.getCouponCode())) {
            log.info("\u672a\u4f7f\u7528\u4f18\u60e0\u5238");
            return new ResponseData();
        }
        if (null != refundCoupon && 1 != refundCoupon) {
            log.info("\u672a\u9009\u62e9\u9000\u5238");
            return new ResponseData();
        }
        this.revertCounpon(stewardOrderPO);
        if (update) {
            this.orderComponent.syncStewardOrder(stewardOrderPO.getStewardOrderCode());
        }
        RightsStewardOrderRefundResponseVO responseVO = new RightsStewardOrderRefundResponseVO();
        responseVO.setOptStatus(update);
        return ResponseUtil.success((Object)responseVO);
    }

    public StewardOrderService(IStewardOrderService stewardOrderService, EvaluateService evaluateService) {
        this.stewardOrderService = stewardOrderService;
        this.evaluateService = evaluateService;
    }
}

