/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.bizvane.rights.api.service.HotelService;
import com.bizvane.rights.api.util.UID;
import com.bizvane.rights.domain.model.entity.RightsHotelPO;
import com.bizvane.rights.domain.service.IRightsHotelService;
import com.bizvane.rights.domain.util.ConvertUtil;
import com.bizvane.rights.domain.util.ResponseUtil;
import com.bizvane.rights.vo.hotel.RightsHotelAddRequestVO;
import com.bizvane.rights.vo.hotel.RightsHotelAddResponseVO;
import com.bizvane.rights.vo.hotel.RightsHotelConditionRequestVO;
import com.bizvane.rights.vo.hotel.RightsHotelDetailResponseVO;
import com.bizvane.rights.vo.hotel.RightsHotelUpdateRequestVO;
import com.bizvane.rights.vo.hotel.RightsHotelUpdateResponseVO;
import com.bizvane.rights.vo.hotel.RightsHotelUpdateStatusRequestVO;
import com.bizvane.rights.vo.hotel.RightsHotelUpdateStatusResponseVO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class HotelServiceImpl
implements HotelService {
    private static final Logger log = LoggerFactory.getLogger(HotelServiceImpl.class);
    private final IRightsHotelService rightsHotelService;

    public RightsHotelDetailResponseVO detail(String rightsHotelCode, List<String> orgCodeList) {
        RightsHotelPO rightsHotelPO = this.rightsHotelService.detailByCodeAndOrgCodeList(rightsHotelCode, orgCodeList);
        return ConvertUtil.po2vo((RightsHotelPO)rightsHotelPO);
    }

    public List<RightsHotelDetailResponseVO> listAll(List<String> orgCodeList) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(RightsHotelPO::getOrgCode, orgCodeList);
        List rightsHotelPOList = this.rightsHotelService.list((Wrapper)queryWrapper);
        List<RightsHotelDetailResponseVO> responseVOList = rightsHotelPOList.stream().map(ConvertUtil::po2vo).collect(Collectors.toList());
        return responseVOList;
    }

    public List<RightsHotelDetailResponseVO> listByCondition(RightsHotelConditionRequestVO requestVO) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(StringUtils.isNotBlank((CharSequence)requestVO.getHotelName()), RightsHotelPO::getHotelName, (Object)requestVO.getHotelName())).eq(StringUtils.isNotBlank((CharSequence)requestVO.getCreateUserName()), RightsHotelPO::getCreateUserName, (Object)requestVO.getCreateUserName())).gt(requestVO.getCreateDateStart() != null, RightsHotelPO::getCreateDate, (Object)requestVO.getCreateDateStart())).lt(requestVO.getCreateDateEnd() != null, RightsHotelPO::getCreateDate, (Object)requestVO.getCreateDateEnd())).in(RightsHotelPO::getOrgCode, (Collection)requestVO.getOrgCodeList())).eq(requestVO.getEnableStatus() != null, RightsHotelPO::getEnableStatus, (Object)requestVO.getEnableStatus())).orderByDesc(RightsHotelPO::getModifiedDate);
        List rightsHotelPOList = this.rightsHotelService.list((Wrapper)queryWrapper);
        List<RightsHotelDetailResponseVO> responseVOList = rightsHotelPOList.stream().map(ConvertUtil::po2vo).collect(Collectors.toList());
        return responseVOList;
    }

    public ResponseData<RightsHotelAddResponseVO> add(RightsHotelAddRequestVO requestVO) {
        long count = this.rightsHotelService.countByHotelCode(requestVO.getHotelCode());
        if (count > 0L) {
            return ResponseUtil.of((SysResponseEnum)SysResponseEnum.RIGHTS_HOTEL_CODE_EXISTS);
        }
        RightsHotelPO rightsHotelPO = new RightsHotelPO();
        rightsHotelPO.setRightsHotelCode(UID.getUid());
        rightsHotelPO.setHotelName(requestVO.getHotelName());
        rightsHotelPO.setHotelCode(requestVO.getHotelCode());
        rightsHotelPO.setHotelPhone(requestVO.getHotelPhone());
        rightsHotelPO.setHotelAddress(requestVO.getHotelAddress());
        rightsHotelPO.setMainImage(requestVO.getMainImage());
        rightsHotelPO.setOtherImage(requestVO.getOtherImage());
        rightsHotelPO.setHotelSummary(requestVO.getHotelSummary());
        rightsHotelPO.setHotelIntroduction(requestVO.getHotelIntroduction());
        rightsHotelPO.setHotelAgreement(requestVO.getHotelAgreement());
        rightsHotelPO.setRemark(requestVO.getRemark());
        rightsHotelPO.setEnableStatus(Boolean.TRUE);
        rightsHotelPO.setOrgCode(requestVO.getOrgCode());
        rightsHotelPO.setLongitude(requestVO.getLongitude());
        rightsHotelPO.setLatitude(requestVO.getLatitude());
        rightsHotelPO.setCreateUserName(requestVO.getOptUserName());
        rightsHotelPO.setCreateUserCode(requestVO.getOptUserCode());
        rightsHotelPO.setLatestCancellationTime(requestVO.getLatestCancellationTime());
        boolean save = this.rightsHotelService.save((Object)rightsHotelPO);
        RightsHotelAddResponseVO responseVO = new RightsHotelAddResponseVO();
        responseVO.setOptStatus(save);
        responseVO.setRightsHotelCode(rightsHotelPO.getRightsHotelCode());
        return ResponseUtil.success((Object)responseVO);
    }

    public ResponseData<RightsHotelUpdateResponseVO> update(RightsHotelUpdateRequestVO requestVO) {
        RightsHotelPO rightsHotelPO = this.rightsHotelService.detailByHotelCode(requestVO.getHotelCode());
        if (rightsHotelPO != null && !rightsHotelPO.getRightsHotelCode().equals(requestVO.getRightsHotelCode())) {
            return ResponseUtil.of((SysResponseEnum)SysResponseEnum.RIGHTS_HOTEL_CODE_EXISTS);
        }
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(RightsHotelPO::getHotelName, (Object)requestVO.getHotelName())).set(RightsHotelPO::getHotelCode, (Object)requestVO.getHotelCode())).set(RightsHotelPO::getHotelPhone, (Object)requestVO.getHotelPhone())).set(RightsHotelPO::getHotelAddress, (Object)requestVO.getHotelAddress())).set(RightsHotelPO::getMainImage, (Object)requestVO.getMainImage())).set(RightsHotelPO::getOtherImage, (Object)requestVO.getOtherImage())).set(RightsHotelPO::getHotelSummary, (Object)requestVO.getHotelSummary())).set(RightsHotelPO::getHotelIntroduction, (Object)requestVO.getHotelIntroduction())).set(RightsHotelPO::getHotelAgreement, (Object)requestVO.getHotelAgreement())).set(RightsHotelPO::getRemark, (Object)requestVO.getRemark())).set(RightsHotelPO::getLongitude, (Object)requestVO.getLongitude())).set(RightsHotelPO::getLatitude, (Object)requestVO.getLatitude())).set(RightsHotelPO::getModifiedUserCode, (Object)requestVO.getOptUserCode())).set(RightsHotelPO::getModifiedUserName, (Object)requestVO.getOptUserName())).set(RightsHotelPO::getLatestCancellationTime, (Object)requestVO.getLatestCancellationTime())).eq(RightsHotelPO::getRightsHotelCode, (Object)requestVO.getRightsHotelCode())).in(RightsHotelPO::getOrgCode, (Collection)requestVO.getOrgCodeList());
        boolean update = this.rightsHotelService.update((Wrapper)updateWrapper);
        RightsHotelUpdateResponseVO responseVO = new RightsHotelUpdateResponseVO();
        responseVO.setOptStatus(update);
        return ResponseUtil.success((Object)responseVO);
    }

    public RightsHotelUpdateStatusResponseVO updateEnableStatus(RightsHotelUpdateStatusRequestVO requestVO) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(RightsHotelPO::getModifiedUserCode, (Object)requestVO.getOptUserCode())).set(RightsHotelPO::getModifiedUserName, (Object)requestVO.getOptUserName())).set(RightsHotelPO::getEnableStatus, (Object)requestVO.getEnableStatus())).eq(RightsHotelPO::getRightsHotelCode, (Object)requestVO.getRightsHotelCode())).in(RightsHotelPO::getOrgCode, (Collection)requestVO.getOrgCodeList());
        boolean update = this.rightsHotelService.update((Wrapper)updateWrapper);
        RightsHotelUpdateStatusResponseVO responseVO = new RightsHotelUpdateStatusResponseVO();
        responseVO.setOptStatus(update);
        return responseVO;
    }

    public HotelServiceImpl(IRightsHotelService rightsHotelService) {
        this.rightsHotelService = rightsHotelService;
    }
}

