/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.service.impl;

import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.bizvane.members.feign.model.vo.MbrMembersDetailVO;
import com.bizvane.payment.feign.vo.req.RefundOrderReqVO;
import com.bizvane.rights.api.service.EvaluateService;
import com.bizvane.rights.api.service.HotelOrderService;
import com.bizvane.rights.api.service.HotelRoomSituationService;
import com.bizvane.rights.api.service.component.CouponComponent;
import com.bizvane.rights.api.service.component.MemberComponent;
import com.bizvane.rights.api.service.component.OrderComponent;
import com.bizvane.rights.api.service.component.PaymentComponent;
import com.bizvane.rights.domain.consts.HotelOrderConst;
import com.bizvane.rights.domain.enums.HotelOrderCancellationTypeEnum;
import com.bizvane.rights.domain.enums.HotelOrderRefundStatusEnum;
import com.bizvane.rights.domain.enums.HotelOrderStatusEnum;
import com.bizvane.rights.domain.enums.HotelRoomSituationOptionTypeEnum;
import com.bizvane.rights.domain.model.entity.RightsHotelOrderDetailPO;
import com.bizvane.rights.domain.model.entity.RightsHotelOrderPO;
import com.bizvane.rights.domain.service.IRightsHotelOrderDetailService;
import com.bizvane.rights.domain.service.IRightsHotelOrderService;
import com.bizvane.rights.domain.service.IRightsHotelService;
import com.bizvane.rights.domain.util.AssertUtil;
import com.bizvane.rights.domain.util.ConvertUtil;
import com.bizvane.rights.domain.util.LocalDateUtils;
import com.bizvane.rights.domain.util.ResponseUtil;
import com.bizvane.rights.enums.EvaluateLabelTypeEnum;
import com.bizvane.rights.enums.HotelOrderPayTypeEnum;
import com.bizvane.rights.mq.HotelOrderCloseMq;
import com.bizvane.rights.vo.evaluate.RightEvaluateRequestVO;
import com.bizvane.rights.vo.evaluate.RightEvaluateResponseVO;
import com.bizvane.rights.vo.hotel.order.RightsHotelBatchOperateOrdersRequestVO;
import com.bizvane.rights.vo.hotel.order.RightsHotelBatchOperateOrdersResponseVO;
import com.bizvane.rights.vo.hotel.order.RightsHotelConfirmOrderCancellationRequestVO;
import com.bizvane.rights.vo.hotel.order.RightsHotelConfirmOrderCancellationResponseVO;
import com.bizvane.rights.vo.hotel.order.RightsHotelOperateOrdersRequestVO;
import com.bizvane.rights.vo.hotel.order.RightsHotelOperateOrdersResponseVO;
import com.bizvane.rights.vo.hotel.order.RightsHotelOrderInfoDetailResponseVO;
import com.bizvane.rights.vo.hotel.order.RightsHotelOrderInfoPageRequestVO;
import com.bizvane.rights.vo.hotel.order.RightsHotelOrderPaymentRequestVO;
import com.bizvane.rights.vo.hotel.order.RightsHotelOrderRefundRequestVO;
import com.bizvane.rights.vo.hotel.order.RightsHotelOrderRefundResponseVO;
import com.bizvane.rights.vo.hotel.order.RightsHotelOrderStatisticsResponseVO;
import com.bizvane.rights.vo.hotel.order.RightsHotelOrderWithEvaluateRequestVO;
import com.bizvane.rights.vo.hotel.order.RightsHotelOrderWithEvaluateResponseVO;
import com.bizvane.rights.vo.hotel.order.RightsHotelOrderWithMemberRequestVO;
import com.bizvane.rights.vo.hotel.order.RightsHotelOrderWithMemberResponseVO;
import com.bizvane.utils.exception.BizException;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class HotelOrderServiceImpl
implements HotelOrderService {
    private static final Logger log = LoggerFactory.getLogger(HotelOrderServiceImpl.class);
    private final IRightsHotelOrderService rightsHotelOrderService;
    private final IRightsHotelService rightsHotelService;
    private final EvaluateService evaluateService;
    private final HotelRoomSituationService hotelRoomSituationService;
    private final IRightsHotelOrderDetailService rightsHotelOrderDetailService;
    private final MemberComponent memberComponent;
    private final PaymentComponent paymentComponent;
    private final OrderComponent orderComponent;
    private final CouponComponent couponComponent;

    public ResponseData<PageInfo<RightsHotelOrderInfoDetailResponseVO>> page(RightsHotelOrderInfoPageRequestVO requestVO) {
        IPage pageList = this.rightsHotelOrderService.pageList(requestVO);
        PageInfo pageInfo = new PageInfo(requestVO.getPageNum().intValue(), requestVO.getPageSize().intValue(), pageList.getTotal(), pageList.getRecords());
        return ResponseUtil.success((Object)pageInfo);
    }

    public ResponseData<RightsHotelOrderStatisticsResponseVO> statistics(RightsHotelOrderInfoPageRequestVO requestVO) {
        RightsHotelOrderStatisticsResponseVO responseVO = new RightsHotelOrderStatisticsResponseVO();
        List rightsHotelPOS = this.rightsHotelService.listByOrgCodeList(requestVO.getOrgCodeList());
        if (CollectionUtils.isEmpty((Collection)rightsHotelPOS)) {
            responseVO.setAll(Long.valueOf(0L));
            responseVO.setToBeConfirmed(Long.valueOf(0L));
            responseVO.setConfirmed(Long.valueOf(0L));
            responseVO.setCheckedIn(Long.valueOf(0L));
            responseVO.setCancelled(Long.valueOf(0L));
            responseVO.setPendingPayment(Long.valueOf(0L));
            return ResponseUtil.success((Object)responseVO);
        }
        List rightsHotelCodeList = rightsHotelPOS.stream().map(rightsHotelPO -> rightsHotelPO.getRightsHotelCode()).collect(Collectors.toList());
        long toBeConfirmed = this.rightsHotelOrderService.countByStatusAndRightsHotelCodeList(Arrays.asList(HotelOrderStatusEnum.TO_BE_CONFIRMED.getOrderStatus()), rightsHotelCodeList);
        long confirmed = this.rightsHotelOrderService.countByStatusAndRightsHotelCodeList(Arrays.asList(HotelOrderStatusEnum.CONFIRMED.getOrderStatus()), rightsHotelCodeList);
        long checkedIn = this.rightsHotelOrderService.countByStatusAndRightsHotelCodeList(Arrays.asList(HotelOrderStatusEnum.CHECKED_IN.getOrderStatus()), rightsHotelCodeList);
        long cancelled = this.rightsHotelOrderService.countByStatusAndRightsHotelCodeList(Arrays.asList(HotelOrderStatusEnum.CANCELLED.getOrderStatus()), rightsHotelCodeList);
        long pendingPayment = this.rightsHotelOrderService.countByStatusAndRightsHotelCodeList(Arrays.asList(HotelOrderStatusEnum.PENDING_PAYMENT.getOrderStatus()), rightsHotelCodeList);
        long all = toBeConfirmed + confirmed + checkedIn + cancelled;
        responseVO.setAll(Long.valueOf(all));
        responseVO.setToBeConfirmed(Long.valueOf(toBeConfirmed));
        responseVO.setConfirmed(Long.valueOf(confirmed));
        responseVO.setCheckedIn(Long.valueOf(checkedIn));
        responseVO.setCancelled(Long.valueOf(cancelled));
        responseVO.setPendingPayment(Long.valueOf(pendingPayment));
        return ResponseUtil.success((Object)responseVO);
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<RightsHotelBatchOperateOrdersResponseVO> batchReject(RightsHotelBatchOperateOrdersRequestVO requestVO) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(RightsHotelOrderPO::getOrderStatus, (Object)HotelOrderStatusEnum.CANCELLED.getOrderStatus())).set(RightsHotelOrderPO::getCancellationType, (Object)HotelOrderCancellationTypeEnum.BACKGROUND.getCancellationType())).set(RightsHotelOrderPO::getCancellationTime, (Object)LocalDateTime.now())).set(RightsHotelOrderPO::getCancellationUserCode, (Object)requestVO.getOptUserCode())).set(RightsHotelOrderPO::getCancellationUserName, (Object)requestVO.getOptUserName())).in(RightsHotelOrderPO::getRightsHotelOrderCode, (Collection)requestVO.getRightsHotelOrderCodeList())).in(RightsHotelOrderPO::getOrderStatus, Arrays.asList(HotelOrderStatusEnum.TO_BE_CONFIRMED.getOrderStatus(), HotelOrderStatusEnum.CONFIRMED.getOrderStatus()));
        boolean update = this.rightsHotelOrderService.update((Wrapper)updateWrapper);
        if (update) {
            for (String rightsHotelOrderCode : requestVO.getRightsHotelOrderCodeList()) {
                this.hotelRoomSituationService.addBatchStock(rightsHotelOrderCode, HotelRoomSituationOptionTypeEnum.FILED_3);
            }
            for (String rightsHotelOrderCode : requestVO.getRightsHotelOrderCodeList()) {
                this.orderComponent.syncHotelOrderAsync(rightsHotelOrderCode);
            }
        }
        RightsHotelBatchOperateOrdersResponseVO responseVO = new RightsHotelBatchOperateOrdersResponseVO();
        responseVO.setOptStatus(update);
        return ResponseUtil.success((Object)responseVO);
    }

    public ResponseData<RightsHotelBatchOperateOrdersResponseVO> batchConfirm(RightsHotelBatchOperateOrdersRequestVO requestVO) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(RightsHotelOrderPO::getOrderStatus, (Object)HotelOrderStatusEnum.CONFIRMED.getOrderStatus())).set(RightsHotelOrderPO::getConfirmTime, (Object)LocalDateTime.now())).set(RightsHotelOrderPO::getConfirmerUserCode, (Object)requestVO.getOptUserCode())).set(RightsHotelOrderPO::getConfirmerUserName, (Object)requestVO.getOptUserName())).in(RightsHotelOrderPO::getRightsHotelOrderCode, (Collection)requestVO.getRightsHotelOrderCodeList())).eq(RightsHotelOrderPO::getOrderStatus, (Object)HotelOrderStatusEnum.TO_BE_CONFIRMED.getOrderStatus());
        boolean update = this.rightsHotelOrderService.update((Wrapper)updateWrapper);
        if (update) {
            for (String rightsHotelOrderCode : requestVO.getRightsHotelOrderCodeList()) {
                this.orderComponent.syncHotelOrderAsync(rightsHotelOrderCode);
            }
        }
        RightsHotelBatchOperateOrdersResponseVO responseVO = new RightsHotelBatchOperateOrdersResponseVO();
        responseVO.setOptStatus(update);
        return ResponseUtil.success((Object)responseVO);
    }

    public ResponseData<RightsHotelBatchOperateOrdersResponseVO> batchCheckIn(RightsHotelBatchOperateOrdersRequestVO requestVO) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(RightsHotelOrderPO::getOrderStatus, (Object)HotelOrderStatusEnum.CHECKED_IN.getOrderStatus())).set(RightsHotelOrderPO::getCheckInTime, (Object)LocalDateTime.now())).set(RightsHotelOrderPO::getCheckInUserCode, (Object)requestVO.getOptUserCode())).set(RightsHotelOrderPO::getCheckInUserName, (Object)requestVO.getOptUserName())).in(RightsHotelOrderPO::getRightsHotelOrderCode, (Collection)requestVO.getRightsHotelOrderCodeList())).eq(RightsHotelOrderPO::getOrderStatus, (Object)HotelOrderStatusEnum.CONFIRMED.getOrderStatus());
        boolean update = this.rightsHotelOrderService.update((Wrapper)updateWrapper);
        if (update) {
            for (String rightsHotelOrderCode : requestVO.getRightsHotelOrderCodeList()) {
                this.orderComponent.syncHotelOrderAsync(rightsHotelOrderCode);
            }
        }
        RightsHotelBatchOperateOrdersResponseVO responseVO = new RightsHotelBatchOperateOrdersResponseVO();
        responseVO.setOptStatus(update);
        return ResponseUtil.success((Object)responseVO);
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<RightsHotelOperateOrdersResponseVO> singleReject(RightsHotelOperateOrdersRequestVO requestVO) {
        RightsHotelOrderPO rightsHotelOrderPO = this.rightsHotelOrderService.detailByCode(requestVO.getRightsHotelOrderCode());
        AssertUtil.notNull((Object)rightsHotelOrderPO, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        HotelOrderPayTypeEnum hotelOrderPayTypeEnum = HotelOrderPayTypeEnum.fromType((Integer)rightsHotelOrderPO.getPayType());
        AssertUtil.notNull((Object)hotelOrderPayTypeEnum, (String)"\u8ba2\u5355\u652f\u4ed8\u65b9\u5f0f\u4e0d\u6b63\u786e");
        if (hotelOrderPayTypeEnum == HotelOrderPayTypeEnum.WECHAT_PAY) {
            return this.wechatReject(requestVO, rightsHotelOrderPO);
        }
        return this.checkInReject(requestVO, rightsHotelOrderPO);
    }

    private ResponseData<RightsHotelOperateOrdersResponseVO> wechatReject(RightsHotelOperateOrdersRequestVO requestVO, RightsHotelOrderPO rightsHotelOrderPO) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(RightsHotelOrderPO::getOrderStatus, (Object)HotelOrderStatusEnum.CANCELLED.getOrderStatus())).set(RightsHotelOrderPO::getRefundStatus, (Object)HotelOrderRefundStatusEnum.REFUND_PROCESSING.getRefundStatus())).set(RightsHotelOrderPO::getCancellationType, (Object)HotelOrderCancellationTypeEnum.BACKGROUND.getCancellationType())).set(RightsHotelOrderPO::getCancellationTime, (Object)LocalDateTime.now())).set(RightsHotelOrderPO::getCancellationUserCode, (Object)requestVO.getOptUserCode())).set(RightsHotelOrderPO::getCancellationUserName, (Object)requestVO.getOptUserName())).set(StringUtils.isNotBlank((CharSequence)requestVO.getHandlingInstructions()), RightsHotelOrderPO::getHandlingInstructions, (Object)requestVO.getHandlingInstructions())).eq(RightsHotelOrderPO::getRightsHotelOrderCode, (Object)requestVO.getRightsHotelOrderCode())).in(RightsHotelOrderPO::getOrderStatus, Arrays.asList(HotelOrderStatusEnum.TO_BE_CONFIRMED.getOrderStatus()));
        boolean update = this.rightsHotelOrderService.update((Wrapper)updateWrapper);
        if (update) {
            if (NumberUtil.isGreater((BigDecimal)rightsHotelOrderPO.getPayableAmount(), (BigDecimal)BigDecimal.ZERO)) {
                RefundOrderReqVO refundOrderReqVO = new RefundOrderReqVO();
                refundOrderReqVO.setOutTradeNo(rightsHotelOrderPO.getOrderNo());
                refundOrderReqVO.setRefundAmount(rightsHotelOrderPO.getPayableAmount());
                refundOrderReqVO.setOrderAmount(rightsHotelOrderPO.getTotalPrices());
                refundOrderReqVO.setOutRefundNo(String.format("R%s", refundOrderReqVO.getOutTradeNo()));
                ResponseData responseData = this.paymentComponent.refundOrder(refundOrderReqVO);
                AssertUtil.judge((Boolean)ResponseUtil.isSuccess((ResponseData)responseData), (String)String.format("\u9152\u5e97\u8ba2\u5355:%s\u53d1\u8d77\u9000\u6b3e\u5931\u8d25", rightsHotelOrderPO.getOrderNo()));
                log.info("paymentComponent.refundOrder:{}", (Object)JSON.toJSONString((Object)responseData));
            } else {
                log.info("\u9000\u6b3e\u91d1\u989d\u4e3a 0\uff0c\u4e0d\u5904\u7406\u5fae\u4fe1\u652f\u4ed8\uff0c\u5355\u72ec\u5904\u7406\u9000\u5238");
                this.couponComponent.couponCorrection(rightsHotelOrderPO, Boolean.TRUE);
            }
            this.orderComponent.syncHotelOrderAsync(requestVO.getRightsHotelOrderCode());
        }
        RightsHotelOperateOrdersResponseVO responseVO = new RightsHotelOperateOrdersResponseVO();
        responseVO.setOptStatus(update);
        return ResponseUtil.success((Object)responseVO);
    }

    private ResponseData<RightsHotelOperateOrdersResponseVO> checkInReject(RightsHotelOperateOrdersRequestVO requestVO, RightsHotelOrderPO rightsHotelOrderPO) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(RightsHotelOrderPO::getOrderStatus, (Object)HotelOrderStatusEnum.CANCELLED.getOrderStatus())).set(RightsHotelOrderPO::getCancellationType, (Object)HotelOrderCancellationTypeEnum.BACKGROUND.getCancellationType())).set(RightsHotelOrderPO::getCancellationTime, (Object)LocalDateTime.now())).set(RightsHotelOrderPO::getCancellationUserCode, (Object)requestVO.getOptUserCode())).set(RightsHotelOrderPO::getCancellationUserName, (Object)requestVO.getOptUserName())).set(StringUtils.isNotBlank((CharSequence)requestVO.getHandlingInstructions()), RightsHotelOrderPO::getHandlingInstructions, (Object)requestVO.getHandlingInstructions())).eq(RightsHotelOrderPO::getRightsHotelOrderCode, (Object)requestVO.getRightsHotelOrderCode())).in(RightsHotelOrderPO::getOrderStatus, Arrays.asList(HotelOrderStatusEnum.TO_BE_CONFIRMED.getOrderStatus()));
        boolean update = this.rightsHotelOrderService.update((Wrapper)updateWrapper);
        if (update) {
            this.hotelRoomSituationService.addBatchStock(requestVO.getRightsHotelOrderCode(), HotelRoomSituationOptionTypeEnum.FILED_3);
            this.orderComponent.syncHotelOrderAsync(requestVO.getRightsHotelOrderCode());
            this.couponComponent.couponCorrection(rightsHotelOrderPO, Boolean.TRUE);
        }
        RightsHotelOperateOrdersResponseVO responseVO = new RightsHotelOperateOrdersResponseVO();
        responseVO.setOptStatus(update);
        return ResponseUtil.success((Object)responseVO);
    }

    public ResponseData<RightsHotelOperateOrdersResponseVO> singleConfirm(RightsHotelOperateOrdersRequestVO requestVO) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(RightsHotelOrderPO::getOrderStatus, (Object)HotelOrderStatusEnum.CONFIRMED.getOrderStatus())).set(RightsHotelOrderPO::getConfirmTime, (Object)LocalDateTime.now())).set(RightsHotelOrderPO::getConfirmerUserCode, (Object)requestVO.getOptUserCode())).set(RightsHotelOrderPO::getConfirmerUserName, (Object)requestVO.getOptUserName())).set(StringUtils.isNotBlank((CharSequence)requestVO.getHandlingInstructions()), RightsHotelOrderPO::getHandlingInstructions, (Object)requestVO.getHandlingInstructions())).eq(RightsHotelOrderPO::getRightsHotelOrderCode, (Object)requestVO.getRightsHotelOrderCode())).eq(RightsHotelOrderPO::getOrderStatus, (Object)HotelOrderStatusEnum.TO_BE_CONFIRMED.getOrderStatus());
        boolean update = this.rightsHotelOrderService.update((Wrapper)updateWrapper);
        if (update) {
            this.orderComponent.syncHotelOrderAsync(requestVO.getRightsHotelOrderCode());
        }
        RightsHotelOperateOrdersResponseVO responseVO = new RightsHotelOperateOrdersResponseVO();
        responseVO.setOptStatus(update);
        return ResponseUtil.success((Object)responseVO);
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<RightsHotelOperateOrdersResponseVO> singleConfirmOrReject(RightsHotelOperateOrdersRequestVO requestVO) {
        if (HotelOrderConst.OPERATE_CHECK_IN.compareTo(requestVO.getOperate()) == 0) {
            return this.singleConfirm(requestVO);
        }
        return this.singleReject(requestVO);
    }

    public ResponseData<RightsHotelOperateOrdersResponseVO> singleCheckIn(RightsHotelOperateOrdersRequestVO requestVO) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(RightsHotelOrderPO::getOrderStatus, (Object)HotelOrderStatusEnum.CHECKED_IN.getOrderStatus())).set(RightsHotelOrderPO::getCheckInTime, (Object)LocalDateTime.now())).set(RightsHotelOrderPO::getCheckInUserCode, (Object)requestVO.getOptUserCode())).set(RightsHotelOrderPO::getCheckInUserName, (Object)requestVO.getOptUserName())).eq(RightsHotelOrderPO::getRightsHotelOrderCode, (Object)requestVO.getRightsHotelOrderCode())).eq(RightsHotelOrderPO::getOrderStatus, (Object)HotelOrderStatusEnum.CONFIRMED.getOrderStatus());
        boolean update = this.rightsHotelOrderService.update((Wrapper)updateWrapper);
        if (update) {
            this.orderComponent.syncHotelOrderAsync(requestVO.getRightsHotelOrderCode());
        }
        RightsHotelOperateOrdersResponseVO responseVO = new RightsHotelOperateOrdersResponseVO();
        responseVO.setOptStatus(update);
        return ResponseUtil.success((Object)responseVO);
    }

    public ResponseData<RightsHotelOrderWithEvaluateResponseVO> detailWithEvaluate(RightsHotelOrderWithEvaluateRequestVO requestVO) {
        RightsHotelOrderPO rightsHotelOrderPO = this.rightsHotelOrderService.detailByCode(requestVO.getRightsHotelOrderCode());
        RightsHotelOrderWithEvaluateResponseVO responseVO = ConvertUtil.po2voWithEvaluate((RightsHotelOrderPO)rightsHotelOrderPO);
        if (rightsHotelOrderPO != null) {
            List rightsHotelOrderDetailPOS = this.rightsHotelOrderDetailService.listByRightsHotelOrderCode(rightsHotelOrderPO.getRightsHotelOrderCode());
            RightsHotelOrderDetailPO rightsHotelOrderDetailPO = (RightsHotelOrderDetailPO)rightsHotelOrderDetailPOS.get(0);
            responseVO.setRoomTypeName(rightsHotelOrderDetailPO.getRoomTypeName());
            responseVO.setRightsHotelRoomTypeCode(responseVO.getRightsHotelRoomTypeCode());
            responseVO.setQuantity(rightsHotelOrderDetailPO.getQuantity());
            RightEvaluateRequestVO evaluateRequestVO = new RightEvaluateRequestVO();
            evaluateRequestVO.setEvaluateType(EvaluateLabelTypeEnum.HOTEL_ORDER.getCode());
            evaluateRequestVO.setOrderNo(rightsHotelOrderPO.getOrderNo());
            ResponseData rightEvaluateResponseVOResponseData = this.evaluateService.detailByTypeAndOrderNo(evaluateRequestVO);
            RightEvaluateResponseVO rightEvaluateResponseVO = (RightEvaluateResponseVO)rightEvaluateResponseVOResponseData.getData();
            responseVO.setEvaluate(rightEvaluateResponseVO);
        }
        return ResponseUtil.success((Object)responseVO);
    }

    public ResponseData<RightsHotelOrderWithMemberResponseVO> detailWithMember(RightsHotelOrderWithMemberRequestVO requestVO) {
        RightsHotelOrderPO rightsHotelOrderPO = this.rightsHotelOrderService.detailByCode(requestVO.getRightsHotelOrderCode());
        RightsHotelOrderWithMemberResponseVO responseVO = ConvertUtil.po2voWithMember((RightsHotelOrderPO)rightsHotelOrderPO);
        if (rightsHotelOrderPO != null) {
            ResponseData mbrMembersDetailVOResponseData = this.memberComponent.detailByMemberCode(rightsHotelOrderPO.getMemberCode());
            MbrMembersDetailVO membersDetailVO = (MbrMembersDetailVO)mbrMembersDetailVOResponseData.getData();
            responseVO.setMembersDetailVO(membersDetailVO);
            List localDates = LocalDateUtils.datesUntil((LocalDate)rightsHotelOrderPO.getExpectedArrivalTime().toLocalDate(), (LocalDate)rightsHotelOrderPO.getExpectedCheckOutTime().toLocalDate());
            List rightsHotelOrderDetailPOS = this.rightsHotelOrderDetailService.listByRightsHotelOrderCode(rightsHotelOrderPO.getRightsHotelOrderCode());
            ArrayList<RightsHotelOrderWithMemberResponseVO.RightsHotelOrderReservationVO> hotelOrderReservationVOList = new ArrayList<RightsHotelOrderWithMemberResponseVO.RightsHotelOrderReservationVO>();
            for (int i = 0; i < localDates.size(); ++i) {
                RightsHotelOrderWithMemberResponseVO.RightsHotelOrderReservationVO rightsHotelOrderReservationVO = new RightsHotelOrderWithMemberResponseVO.RightsHotelOrderReservationVO();
                rightsHotelOrderReservationVO.setSerialNumber(Integer.valueOf(i + 1));
                rightsHotelOrderReservationVO.setCheckInDate((LocalDate)localDates.get(i));
                rightsHotelOrderReservationVO.setCheckInGuest(rightsHotelOrderPO.getReservationName());
                rightsHotelOrderReservationVO.setRoomRate(((RightsHotelOrderDetailPO)rightsHotelOrderDetailPOS.get(0)).getTotalPrices());
                hotelOrderReservationVOList.add(rightsHotelOrderReservationVO);
            }
            responseVO.setRoomTypeName(((RightsHotelOrderDetailPO)rightsHotelOrderDetailPOS.get(0)).getRoomTypeName());
            responseVO.setQuantity(((RightsHotelOrderDetailPO)rightsHotelOrderDetailPOS.get(0)).getQuantity());
            responseVO.setHotelOrderReservationVOList(hotelOrderReservationVOList);
            responseVO.setPayableAmount(rightsHotelOrderPO.getPayableAmount());
            responseVO.setDiscountAmount(rightsHotelOrderPO.getDiscountAmount());
            responseVO.setHotelNights(Integer.valueOf(hotelOrderReservationVOList.size()));
            responseVO.setOrderTime(rightsHotelOrderPO.getCreateDate());
            String checkInAndCheckOut = LocalDateTimeUtil.format((LocalDateTime)rightsHotelOrderPO.getExpectedArrivalTime(), (String)"yyyy-MM-dd") + "~" + LocalDateTimeUtil.format((LocalDateTime)rightsHotelOrderPO.getExpectedCheckOutTime(), (String)"yyyy-MM-dd");
            responseVO.setCheckInAndCheckOut(checkInAndCheckOut);
        }
        return ResponseUtil.success((Object)responseVO);
    }

    public ResponseData<RightsHotelOrderRefundResponseVO> refundCallback(RightsHotelOrderRefundRequestVO requestVO) {
        RightsHotelOrderPO rightsHotelOrderPO = this.rightsHotelOrderService.detailByOrderNo(requestVO.getOutTradeNo());
        AssertUtil.notNull((Object)rightsHotelOrderPO, (String)"\u4e0d\u5b58\u5728\u6b64\u9152\u5e97\u8ba2\u5355");
        String status = requestVO.getStatus();
        if ("SUCCESS".equalsIgnoreCase(status)) {
            return this.refundSuccess(rightsHotelOrderPO);
        }
        if (Arrays.asList("CLOSED", "PROCESSING").contains(status)) {
            return ResponseUtil.success((Object)new RightsHotelOrderRefundResponseVO(), (String)"\u9000\u6b3e\u5173\u95ed,\u9000\u6b3e\u4e2d\u72b6\u6001\u4e0d\u5904\u7406");
        }
        if ("ABNORMAL".equalsIgnoreCase(status)) {
            return this.refundFail(rightsHotelOrderPO);
        }
        throw new BizException("\u672a\u77e5\u7684\u9000\u6b3e\u72b6\u6001,\u4e0d\u5904\u7406");
    }

    public ResponseData<RightsHotelOrderRefundResponseVO> refundSuccess(RightsHotelOrderPO rightsHotelOrderPO) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(RightsHotelOrderPO::getRefundStatus, (Object)HotelOrderRefundStatusEnum.REFUND_SUCCESS.getRefundStatus())).eq(RightsHotelOrderPO::getRightsHotelOrderCode, (Object)rightsHotelOrderPO.getRightsHotelOrderCode())).eq(RightsHotelOrderPO::getOrderStatus, (Object)HotelOrderStatusEnum.CANCELLED.getOrderStatus())).eq(RightsHotelOrderPO::getRefundStatus, (Object)HotelOrderRefundStatusEnum.REFUND_PROCESSING.getRefundStatus());
        boolean update = this.rightsHotelOrderService.update((Wrapper)updateWrapper);
        if (update) {
            this.hotelRoomSituationService.addBatchStock(rightsHotelOrderPO.getRightsHotelOrderCode(), HotelRoomSituationOptionTypeEnum.FILED_3);
            this.orderComponent.syncHotelOrderAsync(rightsHotelOrderPO.getRightsHotelOrderCode());
            this.couponComponent.couponCorrection(rightsHotelOrderPO, null);
        }
        RightsHotelOrderRefundResponseVO responseVO = new RightsHotelOrderRefundResponseVO();
        responseVO.setOptStatus(update);
        return ResponseUtil.success((Object)responseVO);
    }

    private ResponseData<RightsHotelOrderRefundResponseVO> refundFail(RightsHotelOrderPO rightsHotelOrderPO) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(RightsHotelOrderPO::getRefundStatus, (Object)HotelOrderRefundStatusEnum.REFUND_FAIL.getRefundStatus())).eq(RightsHotelOrderPO::getRightsHotelOrderCode, (Object)rightsHotelOrderPO.getRightsHotelOrderCode())).eq(RightsHotelOrderPO::getOrderStatus, (Object)HotelOrderStatusEnum.CANCELLED.getOrderStatus())).eq(RightsHotelOrderPO::getRefundStatus, (Object)HotelOrderRefundStatusEnum.REFUND_PROCESSING.getRefundStatus());
        boolean update = this.rightsHotelOrderService.update((Wrapper)updateWrapper);
        if (update) {
            this.orderComponent.syncHotelOrderAsync(rightsHotelOrderPO.getRightsHotelOrderCode());
        }
        RightsHotelOrderRefundResponseVO responseVO = new RightsHotelOrderRefundResponseVO();
        responseVO.setOptStatus(update);
        return ResponseUtil.success((Object)responseVO);
    }

    public ResponseData<RightsHotelOrderRefundResponseVO> paymentCallback(RightsHotelOrderPaymentRequestVO requestVO) {
        RightsHotelOrderPO rightsHotelOrderPO = this.rightsHotelOrderService.detailByOrderNo(requestVO.getOutTradeNo());
        AssertUtil.notNull((Object)rightsHotelOrderPO, (String)"\u4e0d\u5b58\u5728\u6b64\u9152\u5e97\u8ba2\u5355");
        String tradeState = requestVO.getTradeState();
        if ("SUCCESS".equalsIgnoreCase(tradeState)) {
            return this.paymentSuccess(rightsHotelOrderPO);
        }
        return ResponseUtil.success((Object)new RightsHotelOrderRefundResponseVO(), (String)"\u53ea\u5904\u7406\u652f\u4ed8\u6210\u529f\u7684\u901a\u77e5");
    }

    public ResponseData<RightsHotelOrderRefundResponseVO> paymentSuccess(RightsHotelOrderPO rightsHotelOrderPO) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(RightsHotelOrderPO::getOrderStatus, (Object)HotelOrderStatusEnum.TO_BE_CONFIRMED.getOrderStatus())).set(RightsHotelOrderPO::getPayTime, (Object)LocalDateTime.now())).eq(RightsHotelOrderPO::getRightsHotelOrderCode, (Object)rightsHotelOrderPO.getRightsHotelOrderCode())).eq(RightsHotelOrderPO::getOrderStatus, (Object)HotelOrderStatusEnum.PENDING_PAYMENT.getOrderStatus());
        boolean update = this.rightsHotelOrderService.update((Wrapper)updateWrapper);
        if (update) {
            this.orderComponent.syncHotelOrderAsync(rightsHotelOrderPO.getRightsHotelOrderCode());
        }
        RightsHotelOrderRefundResponseVO responseVO = new RightsHotelOrderRefundResponseVO();
        responseVO.setOptStatus(update);
        return ResponseUtil.success((Object)responseVO);
    }

    public ResponseData<RightsHotelOperateOrdersResponseVO> paymentTimeout(HotelOrderCloseMq requestVO) {
        RightsHotelOrderPO rightsHotelOrderPO = this.rightsHotelOrderService.detailByCode(requestVO.getRightsHotelOrderCode());
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(RightsHotelOrderPO::getOrderStatus, (Object)HotelOrderStatusEnum.CANCELLED.getOrderStatus())).set(RightsHotelOrderPO::getCancellationTime, (Object)LocalDateTime.now())).set(RightsHotelOrderPO::getCancellationType, (Object)HotelOrderCancellationTypeEnum.PAYMENT_TIMEOUT.getCancellationType())).eq(RightsHotelOrderPO::getRightsHotelOrderCode, (Object)rightsHotelOrderPO.getRightsHotelOrderCode())).eq(RightsHotelOrderPO::getOrderStatus, (Object)HotelOrderStatusEnum.PENDING_PAYMENT.getOrderStatus());
        boolean update = this.rightsHotelOrderService.update((Wrapper)updateWrapper);
        if (update) {
            this.hotelRoomSituationService.addBatchStock(rightsHotelOrderPO.getRightsHotelOrderCode(), HotelRoomSituationOptionTypeEnum.FILED_2);
            this.orderComponent.syncHotelOrderAsync(rightsHotelOrderPO.getRightsHotelOrderCode());
            this.couponComponent.couponCorrection(rightsHotelOrderPO, Boolean.TRUE);
        }
        RightsHotelOperateOrdersResponseVO responseVO = new RightsHotelOperateOrdersResponseVO();
        responseVO.setOptStatus(update);
        return ResponseUtil.success((Object)responseVO);
    }

    public ResponseData<RightsHotelConfirmOrderCancellationResponseVO> cancelConfirmedOrder(RightsHotelConfirmOrderCancellationRequestVO requestVO) {
        RightsHotelOrderPO rightsHotelOrderPO = this.rightsHotelOrderService.detailByCode(requestVO.getRightsHotelOrderCode());
        if (rightsHotelOrderPO == null) {
            return ResponseUtil.fail((String)"\u9152\u5e97\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (requestVO.getRefundAmount().compareTo(rightsHotelOrderPO.getPayableAmount()) > 0) {
            return ResponseUtil.fail((String)"\u9000\u6b3e\u91d1\u989d\u9700\u5c0f\u4e8e\u7b49\u4e8e\u652f\u4ed8\u91d1\u989d");
        }
        HotelOrderStatusEnum hotelOrderStatusEnum = HotelOrderStatusEnum.codeByOrderStatus((Integer)rightsHotelOrderPO.getOrderStatus());
        if (hotelOrderStatusEnum == null || hotelOrderStatusEnum != HotelOrderStatusEnum.CONFIRMED) {
            return ResponseUtil.fail((String)"\u9152\u5e97\u8ba2\u5355\u72b6\u6001\u5df2\u53d8\u66f4");
        }
        HotelOrderPayTypeEnum hotelOrderPayTypeEnum = HotelOrderPayTypeEnum.fromType((Integer)rightsHotelOrderPO.getPayType());
        if (hotelOrderPayTypeEnum == HotelOrderPayTypeEnum.WECHAT_PAY) {
            return this.wechatCancel(requestVO, rightsHotelOrderPO);
        }
        return this.checkInCancel(requestVO, rightsHotelOrderPO);
    }

    private ResponseData<RightsHotelConfirmOrderCancellationResponseVO> wechatCancel(RightsHotelConfirmOrderCancellationRequestVO requestVO, RightsHotelOrderPO rightsHotelOrderPO) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(RightsHotelOrderPO::getOrderStatus, (Object)HotelOrderStatusEnum.CANCELLED.getOrderStatus())).set(RightsHotelOrderPO::getRefundStatus, (Object)HotelOrderRefundStatusEnum.REFUND_PROCESSING.getRefundStatus())).set(RightsHotelOrderPO::getCancellationType, (Object)HotelOrderCancellationTypeEnum.BACKGROUND.getCancellationType())).set(RightsHotelOrderPO::getCancellationTime, (Object)LocalDateTime.now())).set(RightsHotelOrderPO::getCancellationUserCode, (Object)requestVO.getOptUserCode())).set(RightsHotelOrderPO::getCancellationUserName, (Object)requestVO.getOptUserName())).set(RightsHotelOrderPO::getRefundAmount, (Object)requestVO.getRefundAmount())).set(RightsHotelOrderPO::getIsCouponRefunded, (Object)requestVO.getIsCouponRefunded())).set(RightsHotelOrderPO::getRefundNote, (Object)requestVO.getRefundNote())).eq(RightsHotelOrderPO::getRightsHotelOrderCode, (Object)requestVO.getRightsHotelOrderCode())).in(RightsHotelOrderPO::getOrderStatus, Arrays.asList(HotelOrderStatusEnum.CONFIRMED.getOrderStatus()));
        boolean update = this.rightsHotelOrderService.update((Wrapper)updateWrapper);
        if (update) {
            if (NumberUtil.isGreater((BigDecimal)requestVO.getRefundAmount(), (BigDecimal)BigDecimal.ZERO)) {
                RefundOrderReqVO refundOrderReqVO = new RefundOrderReqVO();
                refundOrderReqVO.setOutTradeNo(rightsHotelOrderPO.getOrderNo());
                refundOrderReqVO.setRefundAmount(requestVO.getRefundAmount());
                refundOrderReqVO.setOrderAmount(rightsHotelOrderPO.getTotalPrices());
                refundOrderReqVO.setOutRefundNo(String.format("R%s", refundOrderReqVO.getOutTradeNo()));
                ResponseData responseData = this.paymentComponent.refundOrder(refundOrderReqVO);
                AssertUtil.judge((Boolean)ResponseUtil.isSuccess((ResponseData)responseData), (String)String.format("\u9152\u5e97\u8ba2\u5355:%s\u53d1\u8d77\u9000\u6b3e\u5931\u8d25", rightsHotelOrderPO.getOrderNo()));
                log.info("paymentComponent.refundOrder:{}", (Object)JSON.toJSONString((Object)responseData));
            } else {
                log.info("\u9000\u6b3e\u91d1\u989d\u4e3a 0\uff0c\u4e0d\u5904\u7406\u5fae\u4fe1\u652f\u4ed8\uff0c\u5355\u72ec\u5904\u7406\u9000\u5238");
                this.couponComponent.couponCorrection(rightsHotelOrderPO, null);
            }
            this.orderComponent.syncHotelOrderAsync(requestVO.getRightsHotelOrderCode());
        }
        RightsHotelConfirmOrderCancellationResponseVO responseVO = new RightsHotelConfirmOrderCancellationResponseVO();
        responseVO.setOptStatus(update);
        return ResponseUtil.success((Object)responseVO);
    }

    private ResponseData<RightsHotelConfirmOrderCancellationResponseVO> checkInCancel(RightsHotelConfirmOrderCancellationRequestVO requestVO, RightsHotelOrderPO rightsHotelOrderPO) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(RightsHotelOrderPO::getOrderStatus, (Object)HotelOrderStatusEnum.CANCELLED.getOrderStatus())).set(RightsHotelOrderPO::getCancellationType, (Object)HotelOrderCancellationTypeEnum.BACKGROUND.getCancellationType())).set(RightsHotelOrderPO::getCancellationTime, (Object)LocalDateTime.now())).set(RightsHotelOrderPO::getCancellationUserCode, (Object)requestVO.getOptUserCode())).set(RightsHotelOrderPO::getCancellationUserName, (Object)requestVO.getOptUserName())).set(RightsHotelOrderPO::getRefundAmount, (Object)requestVO.getRefundAmount())).set(RightsHotelOrderPO::getIsCouponRefunded, (Object)requestVO.getIsCouponRefunded())).set(RightsHotelOrderPO::getRefundNote, (Object)requestVO.getRefundNote())).eq(RightsHotelOrderPO::getRightsHotelOrderCode, (Object)requestVO.getRightsHotelOrderCode())).in(RightsHotelOrderPO::getOrderStatus, Arrays.asList(HotelOrderStatusEnum.CONFIRMED.getOrderStatus()));
        boolean update = this.rightsHotelOrderService.update((Wrapper)updateWrapper);
        if (update) {
            this.hotelRoomSituationService.addBatchStock(requestVO.getRightsHotelOrderCode(), HotelRoomSituationOptionTypeEnum.FILED_3);
            this.orderComponent.syncHotelOrderAsync(requestVO.getRightsHotelOrderCode());
            this.couponComponent.couponCorrection(rightsHotelOrderPO, requestVO.getIsCouponRefunded());
        }
        RightsHotelConfirmOrderCancellationResponseVO responseVO = new RightsHotelConfirmOrderCancellationResponseVO();
        responseVO.setOptStatus(update);
        return ResponseUtil.success((Object)responseVO);
    }

    public HotelOrderServiceImpl(IRightsHotelOrderService rightsHotelOrderService, IRightsHotelService rightsHotelService, EvaluateService evaluateService, HotelRoomSituationService hotelRoomSituationService, IRightsHotelOrderDetailService rightsHotelOrderDetailService, MemberComponent memberComponent, PaymentComponent paymentComponent, OrderComponent orderComponent, CouponComponent couponComponent) {
        this.rightsHotelOrderService = rightsHotelOrderService;
        this.rightsHotelService = rightsHotelService;
        this.evaluateService = evaluateService;
        this.hotelRoomSituationService = hotelRoomSituationService;
        this.rightsHotelOrderDetailService = rightsHotelOrderDetailService;
        this.memberComponent = memberComponent;
        this.paymentComponent = paymentComponent;
        this.orderComponent = orderComponent;
        this.couponComponent = couponComponent;
    }
}

