/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.basic.feign.enums.ApproveTaskStatusEnum;
import com.bizvane.basic.feign.feign.BasicApproveTaskRpcFeign;
import com.bizvane.basic.feign.feign.SerialNumberServiceFeign;
import com.bizvane.basic.feign.model.req.approve.AddApproveTaskReqVO;
import com.bizvane.basic.feign.model.req.approve.VerifyApproveTaskReqVO;
import com.bizvane.rights.api.service.ApiMktStaffBenefitService;
import com.bizvane.rights.consts.BusinessConst;
import com.bizvane.rights.domain.model.entity.TMktStaffBenefit;
import com.bizvane.rights.domain.service.ITMktStaffBenefitOrgService;
import com.bizvane.rights.domain.service.ITMktStaffBenefitService;
import com.bizvane.rights.domain.service.ITMktStaffBenefitTypeService;
import com.bizvane.rights.domain.util.ResponseUtil;
import com.bizvane.rights.vo.DisableReqVO;
import com.bizvane.rights.vo.UpdateShelfStatusReqVO;
import com.bizvane.rights.vo.UpdateSortReqVO;
import com.bizvane.rights.vo.staffbenefit.AddOrUpdateStaffBenefitReqVO;
import com.bizvane.rights.vo.staffbenefit.QueryStaffBenefitDetailRespVO;
import com.bizvane.rights.vo.staffbenefit.QueryStaffBenefitPageReqVO;
import com.bizvane.rights.vo.staffbenefit.UpdateStaffBenefitCheckStatusReqVO;
import com.bizvane.utils.commonutils.DateUtils;
import com.bizvane.utils.enumutils.ApproveBusinessEnum;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiMktStaffBenefitServiceImpl
implements ApiMktStaffBenefitService {
    private static final Logger log = LoggerFactory.getLogger(ApiMktStaffBenefitServiceImpl.class);
    @Autowired
    private ITMktStaffBenefitService itMktStaffBenefitService;
    @Autowired
    private ITMktStaffBenefitOrgService itMktStaffBenefitOrgService;
    @Autowired
    private ITMktStaffBenefitTypeService itMktStaffBenefitTypeService;
    @Autowired
    private BasicApproveTaskRpcFeign basicApproveTaskRpcFeign;
    @Autowired
    private SerialNumberServiceFeign serialNumberServiceFeign;

    public ResponseData<String> saveOrUpdate(AddOrUpdateStaffBenefitReqVO reqVO) {
        TMktStaffBenefit tMktStaffBenefit = (TMktStaffBenefit)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)reqVO), TMktStaffBenefit.class);
        String mktStaffBenefitCode = reqVO.getMktStaffBenefitCode();
        if (StrUtil.isNotBlank((CharSequence)mktStaffBenefitCode)) {
            tMktStaffBenefit.setModifiedUserCode(reqVO.getOptUserCode());
            tMktStaffBenefit.setModifiedUserName(reqVO.getOptUserName());
            this.itMktStaffBenefitService.update((Object)tMktStaffBenefit, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktStaffBenefit.class).eq(TMktStaffBenefit::getMktStaffBenefitCode, (Object)mktStaffBenefitCode)).eq(TMktStaffBenefit::getValid, (Object)BusinessConst.EFFECTIVE));
        } else {
            tMktStaffBenefit.setMktStaffBenefitCode(IdUtil.fastSimpleUUID());
            tMktStaffBenefit.setValid(BusinessConst.EFFECTIVE);
            tMktStaffBenefit.setCreateUserCode(reqVO.getOptUserCode());
            tMktStaffBenefit.setCreateUserName(reqVO.getOptUserName());
            tMktStaffBenefit.setCheckStatus(ApproveTaskStatusEnum.APPROVE_PASS.getCode());
            tMktStaffBenefit.setEnableStatus(Integer.valueOf(1));
            tMktStaffBenefit.setUpState(Integer.valueOf(1));
            tMktStaffBenefit.setOrgCode(reqVO.getOrgCode());
            this.itMktStaffBenefitService.save((Object)tMktStaffBenefit);
            ResponseData longResponseData = this.serialNumberServiceFeign.generateId();
            log.info("saveOrUpdate generateId: {}", (Object)JacksonUtil.bean2Json((Object)longResponseData));
            VerifyApproveTaskReqVO verifyApproveTaskReqVO = new VerifyApproveTaskReqVO();
            verifyApproveTaskReqVO.setApproveBusiness(ApproveBusinessEnum.STAFF_BENEFITS.getCode());
            verifyApproveTaskReqVO.setApproveRange(reqVO.getOrgCode());
            ResponseData verify = this.basicApproveTaskRpcFeign.verify(verifyApproveTaskReqVO);
            if (verify.getCode() == SysResponseEnum.SUCCESS.getCode() && ObjUtil.equals((Object)verify.getData(), (Object)true)) {
                tMktStaffBenefit.setCheckStatus(ApproveTaskStatusEnum.WAIT_APPROVE.getCode());
                this.itMktStaffBenefitService.updateById((Object)tMktStaffBenefit);
                AddApproveTaskReqVO addApproveTaskReqVO = new AddApproveTaskReqVO();
                addApproveTaskReqVO.setApproveRange(reqVO.getOrgCode());
                addApproveTaskReqVO.setApproveBusiness(ApproveBusinessEnum.STAFF_BENEFITS.getCode());
                addApproveTaskReqVO.setApproveBusinessName(ApproveBusinessEnum.STAFF_BENEFITS.getValue());
                addApproveTaskReqVO.setApproveContent("\u5458\u5de5\u798f\u5229\uff1a" + reqVO.getBenefitName());
                addApproveTaskReqVO.setRefBusinessId(tMktStaffBenefit.getMktStaffBenefitCode());
                addApproveTaskReqVO.setApplyUserCode(reqVO.getOptUserCode());
                addApproveTaskReqVO.setApplyUserName(reqVO.getOptUserName());
                addApproveTaskReqVO.setCreateUserCode(reqVO.getOptUserCode());
                addApproveTaskReqVO.setCreateUserName(reqVO.getOptUserName());
                addApproveTaskReqVO.setApplyTime(new Date());
                addApproveTaskReqVO.setExpireTime(DateUtils.stringFormatTime((String)DateUtils.formatLocalDateTime((LocalDateTime)reqVO.getOpenStartTime())));
                ResponseData add = this.basicApproveTaskRpcFeign.add(addApproveTaskReqVO);
                log.info("saveOrUpdate add: {}", (Object)JacksonUtil.bean2Json((Object)add));
            }
        }
        return ResponseUtil.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    public ResponseData<QueryStaffBenefitDetailRespVO> getDetail(String mktStaffBenefitCode) {
        TMktStaffBenefit tMktStaffBenefit = (TMktStaffBenefit)this.itMktStaffBenefitService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktStaffBenefit.class).eq(TMktStaffBenefit::getMktStaffBenefitCode, (Object)mktStaffBenefitCode)).eq(TMktStaffBenefit::getValid, (Object)BusinessConst.EFFECTIVE));
        QueryStaffBenefitDetailRespVO respVO = (QueryStaffBenefitDetailRespVO)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)tMktStaffBenefit), QueryStaffBenefitDetailRespVO.class);
        return ResponseUtil.success((Object)respVO);
    }

    public ResponseData<PageInfo<QueryStaffBenefitDetailRespVO>> pageList(QueryStaffBenefitPageReqVO reqVO) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktStaffBenefit.class).like(StrUtil.isNotBlank((CharSequence)reqVO.getBenefitName()), TMktStaffBenefit::getBenefitName, (Object)reqVO.getBenefitName())).eq(StrUtil.isNotBlank((CharSequence)reqVO.getCreateUserName()), TMktStaffBenefit::getCreateUserName, (Object)reqVO.getCreateUserName())).gt(reqVO.getOpenStartTime() != null, TMktStaffBenefit::getOpenStartTime, (Object)reqVO.getOpenStartTime())).lt(reqVO.getOpenEndTime() != null, TMktStaffBenefit::getOpenEndTime, (Object)reqVO.getOpenEndTime())).gt(reqVO.getCreateStartDate() != null, TMktStaffBenefit::getCreateDate, (Object)reqVO.getCreateStartDate())).lt(reqVO.getCreateEndDate() != null, TMktStaffBenefit::getCreateDate, (Object)reqVO.getCreateEndDate())).eq(TMktStaffBenefit::getValid, (Object)BusinessConst.EFFECTIVE)).last(" order by create_date desc ");
        if (reqVO.isOrgLimit()) {
            List childrenOrgCodeList = reqVO.getChildrenOrgCodeList();
            if (CollUtil.isNotEmpty((Collection)childrenOrgCodeList)) {
                queryWrapper.in(TMktStaffBenefit::getOrgCode, (Collection)childrenOrgCodeList);
            } else {
                queryWrapper.eq(TMktStaffBenefit::getOrgCode, (Object)"-");
            }
        }
        if (ObjUtil.equals((Object)reqVO.getState(), (Object)4)) {
            queryWrapper.eq(TMktStaffBenefit::getEnableStatus, (Object)0);
        } else if (ObjUtil.equals((Object)reqVO.getState(), (Object)0)) {
            ((LambdaQueryWrapper)queryWrapper.ne(TMktStaffBenefit::getEnableStatus, (Object)0)).and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.gt(TMktStaffBenefit::getOpenStartTime, (Object)LocalDateTime.now())).eq(TMktStaffBenefit::getUpState, (Object)1)).or(orWrapper -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)orWrapper.ne(TMktStaffBenefit::getCheckStatus, (Object)ApproveTaskStatusEnum.APPROVE_PASS.getCode());
                });
            });
        } else if (ObjUtil.equals((Object)reqVO.getState(), (Object)1)) {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lt(TMktStaffBenefit::getOpenStartTime, (Object)LocalDateTime.now())).gt(TMktStaffBenefit::getOpenEndTime, (Object)LocalDateTime.now())).eq(TMktStaffBenefit::getUpState, (Object)1)).ne(TMktStaffBenefit::getEnableStatus, (Object)0)).eq(TMktStaffBenefit::getCheckStatus, (Object)ApproveTaskStatusEnum.APPROVE_PASS.getCode());
        } else if (ObjUtil.equals((Object)reqVO.getState(), (Object)2)) {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lt(TMktStaffBenefit::getOpenStartTime, (Object)LocalDateTime.now())).gt(TMktStaffBenefit::getOpenEndTime, (Object)LocalDateTime.now())).eq(TMktStaffBenefit::getUpState, (Object)0)).ne(TMktStaffBenefit::getEnableStatus, (Object)0)).eq(TMktStaffBenefit::getCheckStatus, (Object)ApproveTaskStatusEnum.APPROVE_PASS.getCode());
        } else if (ObjUtil.equals((Object)reqVO.getState(), (Object)3)) {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lt(TMktStaffBenefit::getOpenEndTime, (Object)LocalDateTime.now())).ne(TMktStaffBenefit::getEnableStatus, (Object)0)).eq(TMktStaffBenefit::getCheckStatus, (Object)ApproveTaskStatusEnum.APPROVE_PASS.getCode());
        }
        IPage page = ((Page)this.itMktStaffBenefitService.page((IPage)new Page((long)reqVO.getPageNum().intValue(), (long)reqVO.getPageSize().intValue()), (Wrapper)queryWrapper)).convert(item -> {
            QueryStaffBenefitDetailRespVO respVO = (QueryStaffBenefitDetailRespVO)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)item), QueryStaffBenefitDetailRespVO.class);
            LocalDateTime openStartTime = item.getOpenStartTime();
            LocalDateTime openEndTime = item.getOpenEndTime();
            Integer upState = item.getUpState();
            Integer enableStatus = item.getEnableStatus();
            Integer checkStatus = item.getCheckStatus();
            if (ObjUtil.equals((Object)enableStatus, (Object)0)) {
                respVO.setState(Integer.valueOf(4));
            } else if (ObjUtil.notEqual((Object)checkStatus, (Object)ApproveTaskStatusEnum.APPROVE_PASS.getCode())) {
                respVO.setState(Integer.valueOf(0));
            } else if (openStartTime.isAfter(LocalDateTime.now())) {
                respVO.setState(Integer.valueOf(0));
            } else if (openStartTime.isBefore(LocalDateTime.now()) && openEndTime.isAfter(LocalDateTime.now()) && ObjUtil.equal((Object)upState, (Object)1)) {
                respVO.setState(Integer.valueOf(1));
            } else if (openStartTime.isBefore(LocalDateTime.now()) && openEndTime.isAfter(LocalDateTime.now()) && ObjUtil.equal((Object)upState, (Object)0)) {
                respVO.setState(Integer.valueOf(2));
            } else if (openEndTime.isBefore(LocalDateTime.now())) {
                respVO.setState(Integer.valueOf(3));
            }
            return respVO;
        });
        PageInfo pageInfo = new PageInfo((int)page.getCurrent(), (int)page.getSize(), page.getTotal(), page.getRecords());
        return ResponseUtil.success((Object)pageInfo);
    }

    public ResponseData<String> updateUpState(UpdateShelfStatusReqVO reqVO) {
        TMktStaffBenefit tMktStaffBenefit = (TMktStaffBenefit)this.itMktStaffBenefitService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktStaffBenefit.class).eq(TMktStaffBenefit::getMktStaffBenefitCode, (Object)reqVO.getCode())).eq(TMktStaffBenefit::getValid, (Object)BusinessConst.EFFECTIVE)).lt(TMktStaffBenefit::getOpenStartTime, (Object)LocalDateTime.now())).gt(TMktStaffBenefit::getOpenEndTime, (Object)LocalDateTime.now()));
        if (tMktStaffBenefit == null) {
            return ResponseUtil.fail((String)"\u5458\u5de5\u798f\u5229\u4e0d\u5b58\u5728\u6216\u4e0d\u5728\u6295\u653e\u4e2d");
        }
        Integer status = reqVO.getStatus();
        status = status <= 0 ? 0 : 1;
        tMktStaffBenefit.setUpState(status);
        tMktStaffBenefit.setModifiedUserName(reqVO.getOptUserName());
        tMktStaffBenefit.setModifiedUserCode(reqVO.getOptUserCode());
        this.itMktStaffBenefitService.update((Object)tMktStaffBenefit, (Wrapper)new LambdaQueryWrapper(TMktStaffBenefit.class).eq(TMktStaffBenefit::getMktStaffBenefitCode, (Object)reqVO.getCode()));
        return ResponseUtil.success((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    public ResponseData<String> updateSort(UpdateSortReqVO reqVO) {
        TMktStaffBenefit tMktStaffBenefit = (TMktStaffBenefit)this.itMktStaffBenefitService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktStaffBenefit.class).eq(TMktStaffBenefit::getMktStaffBenefitCode, (Object)reqVO.getCode())).eq(TMktStaffBenefit::getValid, (Object)BusinessConst.EFFECTIVE));
        if (tMktStaffBenefit == null) {
            return ResponseUtil.fail((String)"\u5458\u5de5\u798f\u5229\u4e0d\u5b58\u5728");
        }
        tMktStaffBenefit.setSort(reqVO.getSort());
        tMktStaffBenefit.setModifiedUserCode(reqVO.getOptUserCode());
        tMktStaffBenefit.setModifiedUserName(reqVO.getOptUserName());
        this.itMktStaffBenefitService.update((Object)tMktStaffBenefit, (Wrapper)new LambdaQueryWrapper(TMktStaffBenefit.class).eq(TMktStaffBenefit::getMktStaffBenefitCode, (Object)reqVO.getCode()));
        return ResponseUtil.success((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    public ResponseData<String> disable(DisableReqVO reqVO) {
        TMktStaffBenefit tMktStaffBenefit = (TMktStaffBenefit)this.itMktStaffBenefitService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktStaffBenefit.class).eq(TMktStaffBenefit::getMktStaffBenefitCode, (Object)reqVO.getCode())).eq(TMktStaffBenefit::getValid, (Object)BusinessConst.EFFECTIVE));
        if (tMktStaffBenefit == null) {
            return ResponseUtil.fail((String)"\u5458\u5de5\u798f\u5229\u4e0d\u5b58\u5728");
        }
        tMktStaffBenefit.setEnableStatus(Integer.valueOf(0));
        tMktStaffBenefit.setModifiedUserName(reqVO.getOptUserName());
        tMktStaffBenefit.setModifiedUserCode(reqVO.getOptUserCode());
        this.itMktStaffBenefitService.update((Object)tMktStaffBenefit, (Wrapper)new LambdaQueryWrapper(TMktStaffBenefit.class).eq(TMktStaffBenefit::getMktStaffBenefitCode, (Object)reqVO.getCode()));
        return ResponseUtil.success((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    public ResponseData<String> updateCheckStatus(UpdateStaffBenefitCheckStatusReqVO reqVO) {
        TMktStaffBenefit tMktStaffBenefit = (TMktStaffBenefit)this.itMktStaffBenefitService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktStaffBenefit.class).eq(TMktStaffBenefit::getMktStaffBenefitCode, (Object)reqVO.getMktStaffBenefitCode())).eq(TMktStaffBenefit::getValid, (Object)BusinessConst.EFFECTIVE));
        if (tMktStaffBenefit == null) {
            return ResponseUtil.fail((String)"\u5458\u5de5\u798f\u5229\u4e0d\u5b58\u5728");
        }
        tMktStaffBenefit.setCheckStatus(reqVO.getCheckStatus());
        tMktStaffBenefit.setCheckRemark(reqVO.getCheckRemark());
        tMktStaffBenefit.setCheckUserCode(reqVO.getOptUserCode());
        tMktStaffBenefit.setCheckUserName(reqVO.getOptUserName());
        tMktStaffBenefit.setModifiedUserName(reqVO.getOptUserName());
        tMktStaffBenefit.setModifiedUserCode(reqVO.getOptUserCode());
        this.itMktStaffBenefitService.update((Object)tMktStaffBenefit, (Wrapper)new LambdaQueryWrapper(TMktStaffBenefit.class).eq(TMktStaffBenefit::getMktStaffBenefitCode, (Object)reqVO.getMktStaffBenefitCode()));
        return ResponseUtil.success((Object)"\u64cd\u4f5c\u6210\u529f");
    }
}

