/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.service.component;

import com.bizvane.basic.feign.feign.BasicMerchantRpcFeign;
import com.bizvane.basic.feign.model.vo.TBasicMerchantVo;
import com.bizvane.rights.domain.util.ResponseUtil;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.exception.BizException;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MerchantComponent {
    private static final Logger log = LoggerFactory.getLogger(MerchantComponent.class);
    private final BasicMerchantRpcFeign basicMerchantRpcFeign;

    public ResponseData<TBasicMerchantVo> queryMerchant(String merchantCode) {
        TBasicMerchantVo merchantVoReqParam = new TBasicMerchantVo();
        merchantVoReqParam.setMerchantCode(merchantCode);
        merchantVoReqParam.setStatus(Boolean.TRUE);
        ResponseData merchantVOListRes = this.basicMerchantRpcFeign.list(merchantVoReqParam);
        if (merchantVOListRes == null) {
            return new ResponseData(SysResponseEnum.NETWORK_ERROR.getCode(), SysResponseEnum.NETWORK_ERROR.getMessage());
        }
        if (merchantVOListRes.getCode() != 0) {
            return new ResponseData(merchantVOListRes.getCode(), merchantVOListRes.getMessage());
        }
        if (CollectionUtils.isEmpty((Collection)((Collection)merchantVOListRes.getData()))) {
            return new ResponseData(SysResponseEnum.MERCHANT_NOT_FOUND.getCode(), SysResponseEnum.MERCHANT_NOT_FOUND.getMessage());
        }
        if (((List)merchantVOListRes.getData()).size() > 1) {
            return new ResponseData(SysResponseEnum.MERCHANT_MATCH_MORE_THAN_ONE.getCode(), SysResponseEnum.MERCHANT_MATCH_MORE_THAN_ONE.getMessage());
        }
        TBasicMerchantVo merchantVo = (TBasicMerchantVo)((List)merchantVOListRes.getData()).get(0);
        return new ResponseData((Object)merchantVo);
    }

    public TBasicMerchantVo getMerchantByOrgCode(String orgCode) {
        TBasicMerchantVo tBasicMerchantVo = new TBasicMerchantVo();
        tBasicMerchantVo.setOrgCode(orgCode);
        ResponseData listResponseData = this.basicMerchantRpcFeign.listByOrgCode(tBasicMerchantVo);
        if (ResponseUtil.isFail((ResponseData)listResponseData)) {
            throw new BizException("\u67e5\u8be2\u5546\u6237\u4fe1\u606f\u5931\u8d25");
        }
        List merchantVoList = (List)listResponseData.getData();
        if (CollectionUtils.isEmpty((Collection)merchantVoList)) {
            throw new BizException("\u7ec4\u7ec7\u672a\u914d\u7f6e\u5546\u6237");
        }
        return (TBasicMerchantVo)merchantVoList.get(0);
    }

    public MerchantComponent(BasicMerchantRpcFeign basicMerchantRpcFeign) {
        this.basicMerchantRpcFeign = basicMerchantRpcFeign;
    }
}

