/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.service.component;

import com.bizvane.basic.feign.model.vo.TBasicMerchantVo;
import com.bizvane.members.feign.model.bo.CouponCalculateDiscountAmountRequestParam;
import com.bizvane.members.feign.model.bo.CouponDefinitionListRequestParam;
import com.bizvane.members.feign.model.bo.CouponEntityAvailableListReq;
import com.bizvane.members.feign.model.bo.CouponEntityRevertRequestParam;
import com.bizvane.members.feign.model.bo.CouponEntityUseRequestParam;
import com.bizvane.members.feign.model.vo.CouponCalculateDiscountAmountVO;
import com.bizvane.members.feign.model.vo.CouponDefinitionVO;
import com.bizvane.members.feign.model.vo.CouponEntityListResponseParam;
import com.bizvane.members.feign.model.vo.CouponEntityUseRsq;
import com.bizvane.members.feign.service.CouponDefFeign;
import com.bizvane.members.feign.service.CouponFeign;
import com.bizvane.rights.domain.model.entity.RightsHotelOrderPO;
import com.bizvane.rights.domain.util.ResponseUtil;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.exception.BizException;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CouponComponent {
    private static final Logger log = LoggerFactory.getLogger(CouponComponent.class);
    @Autowired
    private CouponDefFeign couponDefFeign;
    @Autowired
    private CouponFeign couponFeign;

    public ResponseData<PageInfo<CouponDefinitionVO>> list(List<String> couponDefinitionCodeList) {
        CouponDefinitionListRequestParam param = new CouponDefinitionListRequestParam();
        param.setCouponDefinitionCodeList(couponDefinitionCodeList);
        return this.couponDefFeign.list(param);
    }

    public void couponCorrection(RightsHotelOrderPO rightsHotelOrderPO, Boolean isCouponRefunded) {
        if (StringUtils.isBlank((CharSequence)rightsHotelOrderPO.getCouponNo())) {
            log.info("\u672a\u4f7f\u7528\u4f18\u60e0\u5238\u4e0d\u5904\u7406\u5238\u64a4\u9500\u903b\u8f91");
            return;
        }
        if (BooleanUtils.isFalse((Boolean)isCouponRefunded) && BooleanUtils.isFalse((Boolean)rightsHotelOrderPO.getIsCouponRefunded())) {
            log.info("\u4e0d\u5904\u7406\u5238\u64a4\u9500 isCouponRefunded :{}  isCouponRefundedDB:{}", (Object)isCouponRefunded, (Object)rightsHotelOrderPO.getIsCouponRefunded());
            return;
        }
        CouponEntityRevertRequestParam couponEntityRevertRequestParam = CouponEntityRevertRequestParam.builder().couponNo(rightsHotelOrderPO.getCouponNo()).mbrMembersCode(rightsHotelOrderPO.getMemberCode()).revertTime(LocalDateTime.now()).build();
        ResponseData revert = this.couponFeign.revert(couponEntityRevertRequestParam);
        log.info("couponFeign.revert:{}", (Object)revert);
    }

    public CouponCalculateDiscountAmountVO preUseQuery(CouponCalculateDiscountAmountRequestParam requestParam, TBasicMerchantVo merchantByOrgCode) {
        requestParam.setUseMerchantNo(merchantByOrgCode.getMerchantCode());
        requestParam.setUseIndustryNo(merchantByOrgCode.getBusinessCode());
        requestParam.setUseAirportNo(merchantByOrgCode.getAirportCode());
        ResponseData responseData = this.couponFeign.calculateDiscountAmount(requestParam);
        if (ResponseUtil.isSuccess((ResponseData)responseData)) {
            return (CouponCalculateDiscountAmountVO)responseData.getData();
        }
        if (responseData.getCode() == SysResponseEnum.FAILED.getCode()) {
            throw new BizException("\u8ba1\u7b97\u4f18\u60e0\u5238\u4f18\u60e0\u91d1\u989d\u5931\u8d25");
        }
        return CouponCalculateDiscountAmountVO.builder().discountPrice(BigDecimal.ZERO).build();
    }

    public CouponEntityUseRsq use(CouponEntityUseRequestParam requestParam, TBasicMerchantVo merchantByOrgCode) {
        requestParam.setUseMerchantNo(merchantByOrgCode.getMerchantCode());
        requestParam.setUseIndustryNo(merchantByOrgCode.getBusinessCode());
        requestParam.setUseAirportNo(merchantByOrgCode.getAirportCode());
        ResponseData use = this.couponFeign.use(requestParam);
        if (ResponseUtil.isFail((ResponseData)use)) {
            throw new BizException("\u6838\u9500\u4f18\u60e0\u5238\u5931\u8d25\uff01");
        }
        return (CouponEntityUseRsq)use.getData();
    }

    public ResponseData<PageInfo<CouponEntityListResponseParam>> listAvailable(CouponEntityAvailableListReq requestParam, TBasicMerchantVo merchantByOrgCode) {
        requestParam.setMerchantNo(merchantByOrgCode.getMerchantCode());
        return this.couponFeign.listAvailable(requestParam);
    }
}

