/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.controller;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.rights.api.service.component.OrderComponent;
import com.bizvane.rights.api.service.impl.StewardOrderService;
import com.bizvane.rights.domain.consts.StewardOrderConst;
import com.bizvane.rights.domain.util.AssertUtil;
import com.bizvane.rights.domain.util.ResponseUtil;
import com.bizvane.rights.feign.StewardOrderFeign;
import com.bizvane.rights.vo.OptUserVO;
import com.bizvane.rights.vo.hotel.order.RightsHotelOrderRefundRequestVO;
import com.bizvane.rights.vo.hotel.order.RightsStewardOrderRefundResponseVO;
import com.bizvane.rights.vo.steward.StewardOperateOrdersRequestVO;
import com.bizvane.rights.vo.steward.StewardOperateOrdersResponseVO;
import com.bizvane.rights.vo.steward.StewardOrderDetailReq;
import com.bizvane.rights.vo.steward.StewardOrderQueryReqVO;
import com.bizvane.rights.vo.steward.StewardOrderReqRespVO;
import com.bizvane.rights.vo.steward.StewardOrderStatisticsResponseVo;
import com.bizvane.rights.vo.steward.StewardOrderWithEvaluateRequestVO;
import com.bizvane.rights.vo.steward.StewardOrderWithEvaluateResponseVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/stewardOrderService"})
@Api(value="\u7ba1\u5bb6\u8ba2\u5355", tags={"\u7ba1\u5bb6\u8ba2\u5355"})
public class StewardOrderController
implements StewardOrderFeign {
    @Autowired
    private StewardOrderService stewardService;
    @Autowired
    private OrderComponent orderComponent;

    public ResponseData<PageInfo<StewardOrderReqRespVO>> pageList(@RequestBody StewardOrderQueryReqVO stewardServiceVO) {
        return this.stewardService.pageList(stewardServiceVO);
    }

    public ResponseData<StewardOperateOrdersResponseVO> processingConfirm(@RequestBody StewardOperateOrdersRequestVO requestVO) {
        AssertUtil.notNull((String)requestVO.getStewardOrderCode(), (String)"\u8ba2\u5355code\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.optUserNotNull((OptUserVO)requestVO);
        AssertUtil.notNull((Object)requestVO.getOperate(), (String)"\u5904\u7406\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((Object[])new Object[]{requestVO.getStaffCode(), requestVO.getStaffName(), "\u8bf7\u9009\u62e9\u670d\u52a1\u5458\u5de5"});
        AssertUtil.judge((Boolean)StewardOrderConst.OPERATE_LIST.contains(requestVO.getOperate()), (String)"\u5904\u7406\u7ed3\u679c\u4e0d\u6b63\u786e");
        ResponseData responseData = this.stewardService.processingConfirm(requestVO);
        if (ResponseUtil.isSuccess((ResponseData)responseData) && ((StewardOperateOrdersResponseVO)responseData.getData()).isOptStatus()) {
            this.orderComponent.syncStewardOrder(requestVO.getStewardOrderCode());
        }
        return responseData;
    }

    public ResponseData<StewardOperateOrdersResponseVO> orderReassignment(@RequestBody StewardOperateOrdersRequestVO requestVO) {
        AssertUtil.notNull((String)requestVO.getStewardOrderCode(), (String)"\u8ba2\u5355code\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getStaffCode(), (String)"\u670d\u52a1\u5458\u5de5\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.optUserNotNull((OptUserVO)requestVO);
        ResponseData responseData = this.stewardService.orderReassignment(requestVO);
        return responseData;
    }

    public ResponseData<StewardOperateOrdersResponseVO> orderCancellation(@RequestBody StewardOperateOrdersRequestVO requestVO) {
        AssertUtil.notNull((String)requestVO.getStewardOrderCode(), (String)"\u8ba2\u5355code\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.optUserNotNull((OptUserVO)requestVO);
        AssertUtil.notNull((Object)requestVO.getRefundCoupon(), (String)"\u8bf7\u9009\u62e9\u662f\u5426\u9000\u5238");
        AssertUtil.notNull((Object)requestVO.getRefundAmount(), (String)"\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getRefundInstructions(), (String)"\u9000\u6b3e\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseData responseData = this.stewardService.orderCancellation(requestVO);
        if (ResponseUtil.isSuccess((ResponseData)responseData) && ((StewardOperateOrdersResponseVO)responseData.getData()).isOptStatus()) {
            this.orderComponent.syncStewardOrder(requestVO.getStewardOrderCode());
        }
        return responseData;
    }

    public ResponseData<StewardOrderWithEvaluateResponseVO> orderEvaluation(@RequestBody StewardOrderWithEvaluateRequestVO requestVO) {
        AssertUtil.notNull((String)requestVO.getOrderNo(), (String)"\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        return this.stewardService.orderEvaluation(requestVO);
    }

    public ResponseData<StewardOrderStatisticsResponseVo> statistics() {
        return this.stewardService.statistics();
    }

    public ResponseData<StewardOrderReqRespVO> detailByCode(StewardOrderDetailReq requestVO) {
        AssertUtil.notNull((String)requestVO.getStewardOrderCode(), (String)"\u8ba2\u5355code\u4e0d\u80fd\u4e3a\u7a7a");
        StewardOrderReqRespVO responseVO = this.stewardService.detailByCode(requestVO.getStewardOrderCode());
        return ResponseUtil.success((Object)responseVO);
    }

    public ResponseData<RightsStewardOrderRefundResponseVO> refundCallback(@RequestBody JSONObject jsonObject) {
        RightsHotelOrderRefundRequestVO requestVO = (RightsHotelOrderRefundRequestVO)jsonObject.toJavaObject(RightsHotelOrderRefundRequestVO.class);
        return this.stewardService.refundCallback(requestVO);
    }
}

