/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.controller;

import cn.hutool.core.util.NumberUtil;
import com.bizvane.rights.api.service.HotelRoomTypeService;
import com.bizvane.rights.domain.util.AssertUtil;
import com.bizvane.rights.domain.util.ResponseUtil;
import com.bizvane.rights.feign.HotelRoomTypeFeign;
import com.bizvane.rights.vo.OptUserVO;
import com.bizvane.rights.vo.hotel.roomtype.RightsHotelRoomTypeAddRequestVO;
import com.bizvane.rights.vo.hotel.roomtype.RightsHotelRoomTypeAddResponseVO;
import com.bizvane.rights.vo.hotel.roomtype.RightsHotelRoomTypeBatchUpdateRequestVO;
import com.bizvane.rights.vo.hotel.roomtype.RightsHotelRoomTypeBatchUpdateResponseVO;
import com.bizvane.rights.vo.hotel.roomtype.RightsHotelRoomTypeConditionRequestVO;
import com.bizvane.rights.vo.hotel.roomtype.RightsHotelRoomTypeDetailResponseVO;
import com.bizvane.rights.vo.hotel.roomtype.RightsHotelRoomTypeDisableRequestVO;
import com.bizvane.rights.vo.hotel.roomtype.RightsHotelRoomTypeDisableResponseVO;
import com.bizvane.rights.vo.hotel.roomtype.RightsHotelRoomTypeUpdateRequestVO;
import com.bizvane.rights.vo.hotel.roomtype.RightsHotelRoomTypeUpdateResponseVO;
import com.bizvane.rights.vo.hotel.roomtype.RightsHotelWithRoomTypeVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"hotelRoomType"})
@Api(value="\u9152\u5e97\u623f\u578b", tags={"\u9152\u5e97\u623f\u578b"})
public class HotelRoomTypeController
implements HotelRoomTypeFeign {
    private final HotelRoomTypeService hotelRoomTypeService;

    public ResponseData<RightsHotelRoomTypeDetailResponseVO> detail(@RequestParam(value="rightsHotelRoomTypeCode") String rightsHotelRoomTypeCode) {
        AssertUtil.notNull((String)rightsHotelRoomTypeCode, (String)"\u623f\u578bcode\u4e0d\u80fd\u4e3a\u7a7a");
        RightsHotelRoomTypeDetailResponseVO detail = this.hotelRoomTypeService.detail(rightsHotelRoomTypeCode);
        return ResponseUtil.success((Object)detail);
    }

    public ResponseData<List<RightsHotelRoomTypeDetailResponseVO>> listByCondition(@RequestBody RightsHotelRoomTypeConditionRequestVO requestVO) {
        List detailResponseVOList = this.hotelRoomTypeService.listByCondition(requestVO);
        return ResponseUtil.success((Object)detailResponseVOList);
    }

    public ResponseData<RightsHotelRoomTypeAddResponseVO> add(@RequestBody RightsHotelRoomTypeAddRequestVO requestVO) {
        AssertUtil.optUserNotNull((OptUserVO)requestVO);
        AssertUtil.notNull((String)requestVO.getRightsHotelCode(), (String)"\u6240\u5c5e\u9152\u5e97\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getRoomTypeName(), (String)"\u623f\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getRoomTypeCode(), (String)"\u623f\u578b\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getRoomMainImage(), (String)"\u623f\u578b\u4e3b\u56fe\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getRoomOtherImage(), (String)"\u623f\u578b\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((Object)requestVO.getRoomOriginalPrice(), (String)"\u623f\u578b\u539f\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((Object)requestVO.getRoomMemberPrice(), (String)"\u623f\u578b\u4f1a\u5458\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((Object)requestVO.getRoomEmployeePrice(), (String)"\u623f\u578b\u5458\u5de5\u4f18\u60e0\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.judge((Boolean)NumberUtil.isGreaterOrEqual((BigDecimal)requestVO.getRoomOriginalPrice(), (BigDecimal)NumberUtil.max((BigDecimal[])new BigDecimal[]{requestVO.getRoomMemberPrice(), requestVO.getRoomEmployeePrice()})), (String)"\u623f\u578b\u539f\u4ef7\u4e0d\u80fd\u5c0f\u4e8e\u5458\u5de5\u4ef7\u4f1a\u5458\u4ef7");
        AssertUtil.notNull((String)requestVO.getRoomArea(), (String)"\u623f\u578b\u9762\u79ef\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getBedType(), (String)"\u5e8a\u578b\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getRoomFacilities(), (String)"\u623f\u578b\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        return this.hotelRoomTypeService.add(requestVO);
    }

    public ResponseData<RightsHotelRoomTypeUpdateResponseVO> update(@RequestBody RightsHotelRoomTypeUpdateRequestVO requestVO) {
        AssertUtil.optUserNotNull((OptUserVO)requestVO);
        AssertUtil.notNull((String)requestVO.getRightsHotelCode(), (String)"\u6240\u5c5e\u9152\u5e97\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getRoomTypeName(), (String)"\u623f\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getRoomTypeCode(), (String)"\u623f\u578b\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getRoomMainImage(), (String)"\u623f\u578b\u4e3b\u56fe\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getRoomOtherImage(), (String)"\u623f\u578b\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((Object)requestVO.getRoomOriginalPrice(), (String)"\u623f\u578b\u539f\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((Object)requestVO.getRoomMemberPrice(), (String)"\u623f\u578b\u4f1a\u5458\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((Object)requestVO.getRoomEmployeePrice(), (String)"\u623f\u578b\u5458\u5de5\u4f18\u60e0\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.judge((Boolean)NumberUtil.isGreaterOrEqual((BigDecimal)requestVO.getRoomOriginalPrice(), (BigDecimal)NumberUtil.max((BigDecimal[])new BigDecimal[]{requestVO.getRoomMemberPrice(), requestVO.getRoomEmployeePrice()})), (String)"\u623f\u578b\u539f\u4ef7\u4e0d\u80fd\u5c0f\u4e8e\u5458\u5de5\u4ef7\u4f1a\u5458\u4ef7");
        AssertUtil.notNull((String)requestVO.getRoomArea(), (String)"\u623f\u578b\u9762\u79ef\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getBedType(), (String)"\u5e8a\u578b\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getRoomFacilities(), (String)"\u623f\u578b\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getRightsHotelRoomTypeCode(), (String)"\u623f\u578bcode\u4e0d\u80fd\u4e3a\u7a7a");
        return this.hotelRoomTypeService.update(requestVO);
    }

    public ResponseData<RightsHotelRoomTypeDisableResponseVO> updateEnableStatus(@RequestBody RightsHotelRoomTypeDisableRequestVO requestVO) {
        AssertUtil.optUserNotNull((OptUserVO)requestVO);
        AssertUtil.notNull((Object)requestVO.getEnableStatus(), (String)"\u542f\u7528\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((String)requestVO.getRightsHotelRoomTypeCode(), (String)"\u623f\u578bcode\u4e0d\u80fd\u4e3a\u7a7a");
        RightsHotelRoomTypeDisableResponseVO responseVO = this.hotelRoomTypeService.updateEnableStatus(requestVO);
        return ResponseUtil.success((Object)responseVO);
    }

    public ResponseData<List<RightsHotelWithRoomTypeVO>> listHotelWithRoomType(@RequestBody List<String> orgCodeList) {
        AssertUtil.notEmpty(orgCodeList, (String)"\u7ec4\u7ec7codeList\u4e0d\u80fd\u4e3a\u7a7a");
        List rightsHotelWithRoomTypeVOS = this.hotelRoomTypeService.listHotelWithRoomType(orgCodeList);
        return ResponseUtil.success((Object)rightsHotelWithRoomTypeVOS);
    }

    public ResponseData<RightsHotelRoomTypeBatchUpdateResponseVO> batchUpdatePrice(RightsHotelRoomTypeBatchUpdateRequestVO requestVO) {
        AssertUtil.notEmpty((Collection)requestVO.getRightsHotelRoomTypeCodeList(), (String)"\u8bf7\u9009\u62e9\u623f\u578b");
        AssertUtil.judge((Boolean)ObjectUtils.anyNotNull((Object[])new Object[]{requestVO.getRoomEmployeePrice(), requestVO.getRoomMemberPrice()}), (String)"\u5458\u5de5\u4ef7\u548c\u4f1a\u5458\u4ef7\u5fc5\u987b\u586b\u5199\u4e00\u4e2a\u4ee5\u4e0a");
        AssertUtil.judge((Boolean)(requestVO.getRoomEmployeePrice() == null || requestVO.getRoomEmployeePrice().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0), (String)"\u5458\u5de5\u4ef7\u9700\u8981\u5927\u4e8e 0");
        AssertUtil.judge((Boolean)(requestVO.getRoomMemberPrice() == null || requestVO.getRoomMemberPrice().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0), (String)"\u4f1a\u5458\u4ef7\u9700\u8981\u5927\u4e8e 0");
        RightsHotelRoomTypeBatchUpdateResponseVO responseVO = this.hotelRoomTypeService.batchUpdatePrice(requestVO);
        return ResponseUtil.success((Object)responseVO);
    }

    public HotelRoomTypeController(HotelRoomTypeService hotelRoomTypeService) {
        this.hotelRoomTypeService = hotelRoomTypeService;
    }
}

