/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.controller;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.rights.api.service.HotelOrderService;
import com.bizvane.rights.api.service.component.OrderTemporaryComponent;
import com.bizvane.rights.domain.consts.HotelOrderConst;
import com.bizvane.rights.domain.util.AssertUtil;
import com.bizvane.rights.domain.util.ResponseUtil;
import com.bizvane.rights.feign.HotelOrderFeign;
import com.bizvane.rights.vo.OptUserVO;
import com.bizvane.rights.vo.hotel.order.RightsHotelBatchOperateOrdersRequestVO;
import com.bizvane.rights.vo.hotel.order.RightsHotelBatchOperateOrdersResponseVO;
import com.bizvane.rights.vo.hotel.order.RightsHotelConfirmOrderCancellationRequestVO;
import com.bizvane.rights.vo.hotel.order.RightsHotelConfirmOrderCancellationResponseVO;
import com.bizvane.rights.vo.hotel.order.RightsHotelOperateOrdersRequestVO;
import com.bizvane.rights.vo.hotel.order.RightsHotelOperateOrdersResponseVO;
import com.bizvane.rights.vo.hotel.order.RightsHotelOrderInfoDetailResponseVO;
import com.bizvane.rights.vo.hotel.order.RightsHotelOrderInfoPageRequestVO;
import com.bizvane.rights.vo.hotel.order.RightsHotelOrderPaymentRequestVO;
import com.bizvane.rights.vo.hotel.order.RightsHotelOrderRefundRequestVO;
import com.bizvane.rights.vo.hotel.order.RightsHotelOrderRefundResponseVO;
import com.bizvane.rights.vo.hotel.order.RightsHotelOrderStatisticsResponseVO;
import com.bizvane.rights.vo.hotel.order.RightsHotelOrderWithEvaluateRequestVO;
import com.bizvane.rights.vo.hotel.order.RightsHotelOrderWithEvaluateResponseVO;
import com.bizvane.rights.vo.hotel.order.RightsHotelOrderWithMemberRequestVO;
import com.bizvane.rights.vo.hotel.order.RightsHotelOrderWithMemberResponseVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import java.util.Collection;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"hotelOrder"})
@Api(value="\u9152\u5e97\u4e3b\u4f53", tags={"\u9152\u5e97\u4e3b\u4f53"})
public class HotelOrderController
implements HotelOrderFeign {
    private final HotelOrderService hotelOrderService;
    private final OrderTemporaryComponent orderComponent;

    public ResponseData<PageInfo<RightsHotelOrderInfoDetailResponseVO>> page(@RequestBody RightsHotelOrderInfoPageRequestVO requestVO) {
        return this.hotelOrderService.page(requestVO);
    }

    public ResponseData<RightsHotelOrderStatisticsResponseVO> statistics(@RequestBody RightsHotelOrderInfoPageRequestVO requestVO) {
        return this.hotelOrderService.statistics(requestVO);
    }

    public ResponseData<RightsHotelBatchOperateOrdersResponseVO> batchReject(@RequestBody RightsHotelBatchOperateOrdersRequestVO requestVO) {
        AssertUtil.notEmpty((Collection)requestVO.getRightsHotelOrderCodeList(), (String)"\u8ba2\u5355codeList\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.optUserNotNull((OptUserVO)requestVO);
        return ResponseUtil.fail((String)"\u5df2\u53d6\u6d88\u6279\u91cf\u53d6\u6d88\u529f\u80fd,\u6d89\u53ca\u9000\u6b3e\u903b\u8f91");
    }

    public ResponseData<RightsHotelBatchOperateOrdersResponseVO> batchConfirm(@RequestBody RightsHotelBatchOperateOrdersRequestVO requestVO) {
        AssertUtil.notEmpty((Collection)requestVO.getRightsHotelOrderCodeList(), (String)"\u8ba2\u5355codeList\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.optUserNotNull((OptUserVO)requestVO);
        return this.hotelOrderService.batchConfirm(requestVO);
    }

    public ResponseData<RightsHotelBatchOperateOrdersResponseVO> batchCheckIn(@RequestBody RightsHotelBatchOperateOrdersRequestVO requestVO) {
        AssertUtil.notEmpty((Collection)requestVO.getRightsHotelOrderCodeList(), (String)"\u8ba2\u5355codeList\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.optUserNotNull((OptUserVO)requestVO);
        return this.hotelOrderService.batchCheckIn(requestVO);
    }

    public ResponseData<RightsHotelOperateOrdersResponseVO> singleReject(@RequestBody RightsHotelOperateOrdersRequestVO requestVO) {
        AssertUtil.notNull((String)requestVO.getRightsHotelOrderCode(), (String)"\u8ba2\u5355code\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.optUserNotNull((OptUserVO)requestVO);
        return this.hotelOrderService.singleReject(requestVO);
    }

    public ResponseData<RightsHotelConfirmOrderCancellationResponseVO> cancelConfirmedOrder(@RequestBody RightsHotelConfirmOrderCancellationRequestVO requestVO) {
        AssertUtil.notNull((String)requestVO.getRightsHotelOrderCode(), (String)"\u8ba2\u5355code\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.optUserNotNull((OptUserVO)requestVO);
        AssertUtil.judge((Boolean)(requestVO.getRefundAmount() != null ? 1 : 0), (String)"\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((Object)requestVO.getIsCouponRefunded(), (String)"\u662f\u5426\u9000\u5238\u4e0d\u80fd\u4e3a\u7a7a");
        return this.hotelOrderService.cancelConfirmedOrder(requestVO);
    }

    public ResponseData<RightsHotelOperateOrdersResponseVO> singleConfirm(@RequestBody RightsHotelOperateOrdersRequestVO requestVO) {
        AssertUtil.notNull((String)requestVO.getRightsHotelOrderCode(), (String)"\u8ba2\u5355code\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.optUserNotNull((OptUserVO)requestVO);
        return this.hotelOrderService.singleConfirm(requestVO);
    }

    public ResponseData<RightsHotelOperateOrdersResponseVO> singleConfirmOrReject(@RequestBody RightsHotelOperateOrdersRequestVO requestVO) {
        AssertUtil.notNull((String)requestVO.getRightsHotelOrderCode(), (String)"\u8ba2\u5355code\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.optUserNotNull((OptUserVO)requestVO);
        AssertUtil.notNull((Object)requestVO.getOperate(), (String)"\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.judge((Boolean)HotelOrderConst.OPERATE_LIST.contains(requestVO.getOperate()), (String)"\u64cd\u4f5c\u7c7b\u578b\u4e0d\u6b63\u786e");
        ResponseData responseData = this.hotelOrderService.singleConfirmOrReject(requestVO);
        if (ResponseUtil.isSuccess((ResponseData)responseData) && ((RightsHotelOperateOrdersResponseVO)responseData.getData()).isOptStatus()) {
            this.orderComponent.syncHotelOrderAsync(requestVO.getRightsHotelOrderCode());
        }
        return responseData;
    }

    public ResponseData<RightsHotelOperateOrdersResponseVO> singleCheckIn(@RequestBody RightsHotelOperateOrdersRequestVO requestVO) {
        AssertUtil.notNull((String)requestVO.getRightsHotelOrderCode(), (String)"\u8ba2\u5355code\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.optUserNotNull((OptUserVO)requestVO);
        return this.hotelOrderService.singleCheckIn(requestVO);
    }

    public ResponseData<RightsHotelOrderWithEvaluateResponseVO> detailWithEvaluate(@RequestBody RightsHotelOrderWithEvaluateRequestVO requestVO) {
        AssertUtil.notNull((String)requestVO.getRightsHotelOrderCode(), (String)"rightsHotelOrderCode\u4e0d\u80fd\u4e3a\u7a7a");
        return this.hotelOrderService.detailWithEvaluate(requestVO);
    }

    public ResponseData<RightsHotelOrderWithMemberResponseVO> detailWithMember(@RequestBody RightsHotelOrderWithMemberRequestVO requestVO) {
        AssertUtil.notNull((String)requestVO.getRightsHotelOrderCode(), (String)"rightsHotelOrderCode\u4e0d\u80fd\u4e3a\u7a7a");
        return this.hotelOrderService.detailWithMember(requestVO);
    }

    public ResponseData<RightsHotelOrderRefundResponseVO> refundCallback(@RequestBody JSONObject jsonObject) {
        RightsHotelOrderRefundRequestVO requestVO = (RightsHotelOrderRefundRequestVO)jsonObject.toJavaObject(RightsHotelOrderRefundRequestVO.class);
        return this.hotelOrderService.refundCallback(requestVO);
    }

    public ResponseData<RightsHotelOrderRefundResponseVO> paymentCallback(@RequestBody JSONObject jsonObject) {
        RightsHotelOrderPaymentRequestVO requestVO = (RightsHotelOrderPaymentRequestVO)jsonObject.toJavaObject(RightsHotelOrderPaymentRequestVO.class);
        return this.hotelOrderService.paymentCallback(requestVO);
    }

    public HotelOrderController(HotelOrderService hotelOrderService, OrderTemporaryComponent orderComponent) {
        this.hotelOrderService = hotelOrderService;
        this.orderComponent = orderComponent;
    }
}

