/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.rights.api.controller;

import com.bizvane.rights.api.service.EvaluateLabelService;
import com.bizvane.rights.domain.util.AssertUtil;
import com.bizvane.rights.domain.util.ResponseUtil;
import com.bizvane.rights.feign.EvaluateLabelFeign;
import com.bizvane.rights.vo.OptUserVO;
import com.bizvane.rights.vo.evaluate.EvaluateLabelAddRequestVO;
import com.bizvane.rights.vo.evaluate.EvaluateLabelGroupResponseVO;
import com.bizvane.rights.vo.evaluate.EvaluateLabelRequestVO;
import com.bizvane.rights.vo.evaluate.EvaluateLabelResponseVO;
import com.bizvane.rights.vo.evaluate.RightEvaluateLabelResponseVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import java.util.List;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"evaluateLabel"})
@Api(value="\u8bc4\u4ef7\u6807\u7b7e", tags={"\u8bc4\u4ef7\u6807\u7b7e"})
public class EvaluateLabelController
implements EvaluateLabelFeign {
    private final EvaluateLabelService evaluateLabelService;

    public ResponseData<List<EvaluateLabelGroupResponseVO>> listAll() {
        List responseVOList = this.evaluateLabelService.listAll();
        return ResponseUtil.success((Object)responseVOList);
    }

    public ResponseData<RightEvaluateLabelResponseVO> updateVaild(EvaluateLabelRequestVO requestVO) {
        AssertUtil.optUserNotNull((OptUserVO)requestVO);
        AssertUtil.notNull((String)requestVO.getRightsEvaluateLabelCode(), (String)"\u8bc4\u4ef7\u6807\u7b7ecode\u4e0d\u80fd\u4e3a\u7a7a");
        RightEvaluateLabelResponseVO responseVO = this.evaluateLabelService.updateVaild(requestVO);
        return ResponseUtil.success((Object)responseVO);
    }

    public ResponseData<RightEvaluateLabelResponseVO> add(EvaluateLabelAddRequestVO requestVO) {
        AssertUtil.optUserNotNull((OptUserVO)requestVO);
        AssertUtil.notNull((String)requestVO.getLabelName(), (String)"\u6807\u7b7e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.notNull((Object)requestVO.getLabelType(), (String)"\u6807\u7b7e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        return this.evaluateLabelService.add(requestVO);
    }

    public ResponseData<EvaluateLabelResponseVO> detailByCode(String rightsEvaluateLabelCode) {
        AssertUtil.notNull((String)rightsEvaluateLabelCode, (String)"\u6807\u7b7ecode\u4e0d\u80fd\u4e3a\u7a7a");
        EvaluateLabelResponseVO responseVO = this.evaluateLabelService.detailByCode(rightsEvaluateLabelCode);
        return ResponseUtil.success((Object)responseVO);
    }

    public ResponseData<List<EvaluateLabelResponseVO>> detailByLabelType(Integer labelType) {
        AssertUtil.notNull((Object)labelType, (String)"\u6807\u7b7e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        List responseVO = this.evaluateLabelService.detailByLabelType(labelType);
        return ResponseUtil.success((Object)responseVO);
    }

    public EvaluateLabelController(EvaluateLabelService evaluateLabelService) {
        this.evaluateLabelService = evaluateLabelService;
    }
}

