package com.bizvane.platform.feign.feign.douyin;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;


@FeignClient(value = "${feign.client.platform.name}", path = "${feign.client.platform.path}/douyin")
public interface DouyinAuthRpcFeign {


    @GetMapping("/authGetQrCode")
    @ResponseBody
    @ApiOperation(value = "获取抖音授权二维码")
    ResponseData<JSONObject> authQrCode();


    @GetMapping("/authCheckQrCode")
    @ResponseBody
    @ApiOperation(value = "检查抖音授权二维码")
    ResponseData<String> authCheckQrCode(@RequestParam String token, @RequestParam String state, @RequestParam String accountCode);


    @GetMapping("/auth")
    @ResponseBody
    @ApiOperation(value = "授权")
    ResponseEntity<String> auth();


    @GetMapping("/authCallback")
    @ResponseBody
    @ApiOperation(value = "抖音授权回调")
    ResponseEntity<String> authCallback(@RequestParam String code, @RequestParam String state, @RequestParam String accountCode);


}
