package com.bizvane.platform.feign.feign.basic;


import com.bizvane.platform.feign.model.vo.TSysToolsConfigVo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

@FeignClient(value = "${feign.client.platform.name}", path = "${feign.client.platform.path}" + "/tSysToolsConfig")
@Api(value = "工具配置RPC")
public interface SysToolsConfigRpcFeign {


    @RequestMapping(value = "/list", method = RequestMethod.POST)
    @ApiOperation(value = "列表")
    ResponseData<List<TSysToolsConfigVo>> list(@RequestBody TSysToolsConfigVo req);

    @RequestMapping(value = "/detail", method = RequestMethod.POST)
    @ApiOperation(value = "详情")
    ResponseData<TSysToolsConfigVo> detail(@RequestBody TSysToolsConfigVo req);


}
