package com.bizvane.platform.feign.feign.basic;


import com.bizvane.platform.feign.model.req.TBasicStaffPageReq;
import com.bizvane.platform.feign.model.vo.TSysStaffVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

@FeignClient(value = "${feign.client.platform.name}", path = "${feign.client.platform.path}" + "/tSysStaff")
@Api(value = "员工信息RPC")
public interface SysStaffRpcFeign {


    @RequestMapping(value = "/appLogin", method = RequestMethod.POST)
    @ApiOperation(value = "小程序登录")
    ResponseData<TSysStaffVo> appLogin(@RequestBody TSysStaffVo req);

    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ApiOperation(value = "分页条件查询列表")
    ResponseData<PageInfo<TSysStaffVo>> pageList(@RequestBody TBasicStaffPageReq req);

    @RequestMapping(value = "/list", method = RequestMethod.POST)
    @ApiOperation(value = "员工列表")
    ResponseData<List<TSysStaffVo>> list(@RequestBody TSysStaffVo req);

    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(value = "添加员工")
    ResponseData<Boolean> save(@RequestBody TSysStaffVo req);

    @RequestMapping(value = "/modify", method = RequestMethod.POST)
    @ApiOperation(value = "编辑员工")
    ResponseData<Boolean> modify(@RequestBody TSysStaffVo req);

    @RequestMapping(value = "/detail", method = RequestMethod.POST)
    @ApiOperation(value = "详情")
    ResponseData<TSysStaffVo> detail(@RequestBody TSysStaffVo req);


}
