package com.bizvane.platform.feign.feign.basic;

import com.bizvane.platform.feign.model.vo.TBasicTenantMenuVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value = "${feign.client.platform.name}", path = "${feign.client.platform.path}" + "/tBasicTenantMenu")
@Api(value = "租户菜单RPC")
public interface BasicTenantMenuRpcFeign {


    @RequestMapping(value = "/getTenantMenuAndBtnList", method = RequestMethod.GET)
    @ApiOperation(value = "获取租户所有菜单、按钮列表")
    ResponseData<List<TBasicTenantMenuVO>> getAllMenuAndBtnList(@RequestParam("tenantId") String tenantId);

}
