package com.bizvane.platform.feign.feign.basic;


import com.bizvane.platform.feign.model.vo.RegionModel;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

@FeignClient(value = "${feign.client.basic.name}", path = "${feign.client.basic.path}" + "/basicRegion")
@Api(value = "地区RPC")
public interface BasicRegionRpcFeign {


    @RequestMapping(value = "/queryRegion", method = RequestMethod.GET)
    @ApiOperation(value = "获取省市区")
    ResponseData<List<RegionModel>> queryRegion();

}
