package com.bizvane.payment.feign.api;

import com.bizvane.payment.feign.vo.NotifyOrderRefundVO;
import com.bizvane.payment.feign.vo.req.*;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(value = "${feign.client.payment.name}", path = "${feign.client.payment.path}/apiWechatRefund")
public interface UnifiedPaymentRefundFeign {

    @PostMapping("/refundOrder")
    ResponseData<String> refundOrder(@RequestBody RefundOrderReqVO reqVO);

    @PostMapping("/queryRefundOrder")
    ResponseData<NotifyOrderRefundVO> queryRefundOrder(@RequestBody QueryOrderRefundReqVO reqVO);
}
