package com.bizvane.payment.feign.vo.req;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

@Data
public class IcbcPayFrozenRecordAddReqVO implements Serializable {

    @ApiModelProperty("商户支付配置系统编号code")
    @NotBlank(message = "商户支付配置系统编号code不能为空")
    private String paymentMerchantConfigCode;

    @ApiModelProperty("工行交易日期")
    @NotNull(message = "工行交易日期不能为空")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate icbcTrxDate;

    @ApiModelProperty("工行交易时间")
    @NotBlank(message = "工行交易时间不能为空")
    private String icbcTrxTime;

    @ApiModelProperty("工行服务商编号")
    @NotBlank(message = "工行服务商编号不能为空")
    private String icbcSerNo;

    @ApiModelProperty("工行外部商户编号")
    private String icbcOutMerNo;

    @ApiModelProperty("工行内部协议编号")
    private String icbcInAgreeNo;

    @NotBlank(message = "工行外部协议编号不能为空")
    @ApiModelProperty("工行外部协议编号")
    private String icbcOutAgreeNo;

    @NotBlank(message = "工行订单号不能为空")
    @ApiModelProperty("工行订单号")
    private String icbcOrderNo;

    @NotBlank(message = "工行订单子序号不能为空")
    @ApiModelProperty("工行订单子序号")
    private String icbcOrderSubNo;

    @ApiModelProperty("工行交易流水号")
    private String icbcTrxSerialNo;

    @NotNull(message = "工行总冻结金额不能为空")
    @ApiModelProperty("工行总冻结金额")
    private BigDecimal icbcTotalFrozenAmt;

    @NotNull(message = "工行已退冻结金额不能为空")
    @ApiModelProperty("工行已退冻结金额")
    private BigDecimal icbcRetFrozenAmt;

    @NotNull(message = "工行未解冻金额不能为空")
    @ApiModelProperty("工行未解冻金额")
    private BigDecimal icbcUnThawAmt;

    @NotNull(message = "记录状态不能为空")
    @ApiModelProperty("记录状态 1冻结 2待分账(已解冻) 3已分账")
    private Integer recordState;
}
