package com.bizvane.payment.feign.vo.req;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;

@Data
public class IcbcPayFrozenRecordSliptReqVO implements Serializable {
    private static final long serialVersionUID = 1L;

    @NotEmpty(message = "入账记录编号不能为空")
    @ApiModelProperty("工行入账记录表编号code")
    private String paymentIcbcFrozenRecordCode;

    @NotEmpty(message = "商户支付配置系统编号code不能为空")
    @ApiModelProperty("商户支付配置系统编号code")
    private String paymentMerchantConfigCode;

    @NotEmpty(message = "操作人不能为空")
    @ApiModelProperty("操作人code")
    private String operationUserCode;

    @NotEmpty(message = "操作人不能为空")
    @ApiModelProperty("操作人姓名")
    private String operationUserName;
}
