package com.bizvane.payment.feign.vo.resp;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Time;
import java.util.Date;

@Data
public class IcbcPayFrozenRecordPullRespVO implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("工行交易日期")
    private Date icbcTrxDate;

    @ApiModelProperty("工行交易时间")
    private Time icbcTrxTime;

    @ApiModelProperty("工行服务商编号")
    private String icbcSerNo;

    @ApiModelProperty("工行外部商户编号")
    private String icbcOutMerNo;

    @ApiModelProperty("工行内部协议编号")
    private String icbcInAgreeNo;

    @ApiModelProperty("工行外部协议编号")
    private String icbcOutAgreeNo;

    @ApiModelProperty("工行订单号")
    private String icbcOrderNo;

    @ApiModelProperty("工行订单子序号")
    private String icbcOrderSubNo;

    @ApiModelProperty("工行交易流水号")
    private String icbcTrxSerialNo;

    @ApiModelProperty("记录状态 1冻结 2待分账(已解冻) 3已分账")
    private Integer icbcTrawStat;

    @ApiModelProperty("工行总冻结金额")
    private BigDecimal icbcTotalFrozenAmt;

    @ApiModelProperty("工行已退冻结金额")
    private BigDecimal icbcRetFrozenAmt;

    @ApiModelProperty("工行未解冻金额")
    private BigDecimal icbcUnThawAmt;
}
