package com.bizvane.openapi.business.shell;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

import com.bizvane.openapi.business.modules.business.entity.OpenapiBusinessMain;
import com.bizvane.openapi.business.modules.business.service.OpenapiBusinessMainService;

/**
 * 
 * @author wang.zeyan
 *  2019年6月10日
 */
@ShellComponent
public class BusinessCommands {

	@Autowired
	OpenapiBusinessMainService businessService;
	
	@ShellMethod("添加商户")
    public String addBusiness(
    		@ShellOption(help = "商户号(企业编号)") String businessId,
    		@ShellOption(help = "商户登陆账号") String account,
    		@ShellOption(help = "商户登陆密码") String password) {
		OpenapiBusinessMain entity = new OpenapiBusinessMain();
		entity.setId(businessId).setAccount(account).setPassword(password);
		return businessService.save(entity) ? "添加成功" : "添加失败";
    }
	
	@ShellMethod("修改商户密码")
	public String updateBusinessPassword(
			@ShellOption(help = "商户号") String account,
			@ShellOption(help = "密码") String password,
			@ShellOption(help = "二次密码") String duplicatePassword) {
		
		if(!password.equals(duplicatePassword)) {
			return "两次密码不一致";
		}
		OpenapiBusinessMain entity = new OpenapiBusinessMain();
		entity.setPassword(password);
		return businessService.updateByAccount(entity, account) ? "修改成功" : "修改失败";
	}
	
}
