/*package com.bizvane.openapi.authentication;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import java.util.TreeMap;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.alibaba.fastjson.JSON;
import com.bizvane.openapi.authentication.vo.KeyPairVO;
import com.google.common.collect.Maps;

*//**
 * RSA 签名,验签
 * @author wang.zeyan
 *  2019年4月15日
 *//*
public class RsaEncryptedEncoder implements EncryptedEncoder {

	Logger logger = LoggerFactory.getLogger(RsaEncryptedEncoder.class);
	
	final static String ALGORITHM = "RSA";
	final static String DEFAULT_CHARSET = "UTF-8";
	final static String SINGATRUE_ALGORITHM = "MD5withRSA";
	static KeyPairGenerator keyPairGenerator = null;
	static KeyFactory keyFactory = null;
	static {
		try {
			keyPairGenerator = KeyPairGenerator.getInstance(ALGORITHM);
			keyPairGenerator.initialize(1024);
			
			keyFactory = KeyFactory.getInstance(ALGORITHM);
		} catch (NoSuchAlgorithmException e) {
			//skip
		}
	}
	
	@Override
	public KeyPair generate(){
		return keyPairGenerator.generateKeyPair();
	}
	
	@Override
	public KeyPairVO generateVO() {
		try {
			java.security.KeyPair keyPair = generate();
			PrivateKey privateKey = keyPair.getPrivate();
			PublicKey publicKey = keyPair.getPublic();
			KeyPairVO result = new KeyPairVO();
			result.setPrivateKey(new String(ENCODER.encode(privateKey.getEncoded()), DEFAULT_CHARSET));
			result.setPublicKey(new String(ENCODER.encode(publicKey.getEncoded()), DEFAULT_CHARSET));
			return result;
		} catch (UnsupportedEncodingException e) {
			// skip 不支持的编码
		}
		return null;
	}
	
	@Override
	public PrivateKey getPrivateKey(String privateKey) {
		byte [] decoderKey = DECODER.decode(privateKey.getBytes());
		PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(decoderKey);
		try {
			return keyFactory.generatePrivate(keySpec);
		} catch (InvalidKeySpecException e) {
			logger.error("无效的私钥", e);
			throw new IllegalArgumentException("invalid privateKey");
		}
	}


	@Override
	public PublicKey getPublicKey(String publicKey) {
		byte [] decoderKey = DECODER.decode(publicKey.getBytes());
		X509EncodedKeySpec keySpec = new X509EncodedKeySpec(decoderKey);
		try {
			return keyFactory.generatePublic(keySpec);
		} catch (InvalidKeySpecException e) {
			logger.error("无效的公钥", e);
			throw new IllegalArgumentException("invalid publicKey");
		}
	}
	

	@Override
	public String sign(String privateKey, String rawData) {
		if(logger.isDebugEnabled()) {
			logger.debug("privateKey:{}", privateKey);
			logger.debug("rawData:{}", rawData);
		}
		if(privateKey == null || privateKey.trim().length() == 0) {
			throw new IllegalArgumentException("PrivateKey cannot be null");
		}
		if(rawData == null || rawData.trim().length() == 0) {
			throw new IllegalArgumentException("RawData cannot be null");
		}
		
		PrivateKey pk = getPrivateKey(privateKey);
		try {
			Signature singatrue = Signature.getInstance(SINGATRUE_ALGORITHM);
			singatrue.initSign(pk);
			singatrue.update(rawData.getBytes());
			String sign = new String(ENCODER.encode(singatrue.sign()), DEFAULT_CHARSET);
			return sign;
		} catch (InvalidKeyException | NoSuchAlgorithmException | UnsupportedEncodingException e) {
			// skip
		} catch (SignatureException e) {
			logger.error("签名异常", e);
		} 
		return null;
	}

	@Override
	public String sign(String privateKey, Map<String, Object> map) {
		if(map == null || map.size() == 0) {
			throw new IllegalArgumentException("Map cannot be null");
		}
		if(map instanceof TreeMap) {
			return sign(privateKey, (TreeMap<String, Object>)map);
		}
		
		TreeMap<String, Object> treeMap = Maps.newTreeMap();
		treeMap.putAll(map);
		return sign(privateKey, treeMap);
	}

	@Override
	public String sign(String privateKey, TreeMap<String, Object> treeMap) {
		if(treeMap == null || treeMap.size() == 0) {
			throw new IllegalArgumentException("TreeMap cannot be null");
		}
		return sign(privateKey, JSON.toJSONString(treeMap));
	}

	@Override
	public boolean verifySign(String publicKey, String rawData, String sign) {
		
		if(logger.isDebugEnabled()) {
			logger.debug("publicKey:{}", publicKey);
			logger.debug("rawData:{}", rawData);
			logger.debug("sign:{}", sign);
		}
		if(publicKey == null || publicKey.trim().length() == 0) {
			throw new IllegalArgumentException("PublicKey cannot be null");
		}
		if(rawData == null || rawData.trim().length() == 0) {
			throw new IllegalArgumentException("RawData cannot be null");
		}
		if(sign == null || sign.trim().length() == 0) {
			throw new IllegalArgumentException("Signature cannot be null");
		}
		
		PublicKey pk = getPublicKey(publicKey);
		try {
			Signature singatrue = Signature.getInstance(SINGATRUE_ALGORITHM);
			singatrue.initVerify(pk);
			singatrue.update(rawData.getBytes());
			boolean verify = singatrue.verify(DECODER.decode(sign.getBytes()));
			return verify;
		} catch (InvalidKeyException | NoSuchAlgorithmException e) {
			// skip
		} catch (SignatureException e) {
			logger.error("签名异常", e);
		}
		return false;
	}

	@Override
	public boolean verifySign(String publicKey, Map<String, Object> map, String sign) {
		if(map == null || map.size() == 0) {
			throw new IllegalArgumentException("Map cannot be null");
		}
		if(map instanceof TreeMap) {
			return verifySign(publicKey, (TreeMap<String, Object>)map, sign);
		}
		
		TreeMap<String, Object> treeMap = Maps.newTreeMap();
		treeMap.putAll(map);
		return verifySign(publicKey, treeMap, sign);
	}

	@Override
	public boolean verifySign(String publicKey, TreeMap<String, Object> treeMap, String sign) {
		if(treeMap == null || treeMap.size() == 0) {
			throw new IllegalArgumentException("TreeMap cannot be null");
		}
		String rawData = JSON.toJSONString(treeMap);
		return verifySign(publicKey, rawData, sign);
	}

	@Override
	public String getAlgorithm() {
		return ALGORITHM;
	}
}
*/