package com.bizvane.openapi.authentication;

import java.util.Map;

import com.bizvane.openapi.authentication.vo.Client;
import com.bizvane.openapi.authentication.vo.Token;

/**
 * 
 * @author wang.zeyan
 *  2019年4月12日
 */
public interface AuthenticationService {

	/**
	 * 生成 客户端/开发者账号/服务者账号
	 * @return
	 */
	Client generateClient();
	
	/**
	 * 缓存 客户端/开发者账号/服务者账号
	 * @param client
	 */
	public <T extends Client> void cacheClient(T client);
	
	/**
	 * 获取token
	 * @param appKey
	 * @param appSecret
	 * @return
	 */
	Token accessToken(String appKey, String appSecret);
	
	/**
	 * 获取token
	 * @param client
	 * @return
	 */
	Token accessToken(Client client);
	
	/**
	 * 刷新token
	 * @param appKey
	 * @param refreshToken
	 * @return
	 */
	Token refreshToken(String appKey, String refreshToken);
	
	/**
	 * 验证签名
	 * @param sign
	 * @param accessToken
	 * @param params
	 * @return
	 */
	boolean verifySignature(String sign, String accessToken, Map<String, Object> params); 
	
	/**
	 * 签名
	 * @param appKey
	 * @param params
	 * @return
	 */
	String signature(String appKey, Map<String, Object> params);

	/**
	 * 获取当前accessToken开发者账号信息
	 * @param accessToken
	 * @return
	 */
	Client getClient(String accessToken);

	/**
	 * 根据appKey获取开发者账号信息
	 * @param appKey
	 * @return
	 */
	Client getClientWithAppKey(String appKey);
}
