package com.bizvane.openapifacade.rpc;

import com.bizvane.openapifacade.models.vo.MemberOpenCard361RequestVo;
import com.bizvane.openapifacade.models.vo.MemberOpenCard361ResponseVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * @author baofeng@smzdm.com
 * @createTime 2024-10-25 17:56:55
 * @description: 361开放平台RPC接口
 */

@FeignClient(value = "${feign.client.openapi.name}", path = "${feign.client.openapi.path}/api361")
public interface Openapi361Rpc {

    @PostMapping(value = "/openCard")
    ResponseData<MemberOpenCard361ResponseVo> openCard(@RequestBody @Valid MemberOpenCard361RequestVo requestVo);

}
