package com.bizvane.openapifacade.models.vo;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;

@Data
public class VGCouponReceiveRequestVO {
    //品牌code
    @NotBlank
    private String brandCode;

    //券code
    @NotBlank
    private String couponCode;

    //会员卡号
    @NotBlank
    private String cardNo;

    //券规则code
    @NotBlank
    private String couponRuleCode;

    //券有效开日期
    @NotBlank
    private String validDateStart;

    //券有效结束日期
    @NotBlank
    private String validDateEnd;

    //券类型（1现金，2折扣，3礼品）
    @NotBlank
    private String preferentialType;

    //券名称
    private String couponName;

    //券面额(如果券类型为1时，必填)
    private BigDecimal money;

    //券折扣(折扣券时传⼩数位，88折示例：8.8 。 如果券类型为2时，必填)
    private BigDecimal discount;

    //券描述
    private String info;

}
