/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.quickbi.openapi.client;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.quickbi.openapi.client.AbstractHttpClient;
import com.alibaba.quickbi.openapi.client.FormatType;
import com.alibaba.quickbi.openapi.client.HttpRequest;
import com.alibaba.quickbi.openapi.client.HttpResponse;
import com.alibaba.quickbi.openapi.client.IOpenAPIClient;
import com.alibaba.quickbi.openapi.client.ParameterUtil;
import com.alibaba.quickbi.openapi.common.signature.SignatureUtil;
import com.alibaba.quickbi.openapi.core.config.HttpClientConfig;
import com.alibaba.quickbi.openapi.core.exception.ClientException;
import com.alibaba.quickbi.openapi.core.exception.SDKException;
import com.alibaba.quickbi.openapi.core.util.OpenAPILoggerUtils;
import com.alibaba.quickbi.openapi.core.util.StringUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class OpenApiClientHttpClient
extends AbstractHttpClient
implements IOpenAPIClient {
    private String host;
    private String rootPath;
    private boolean encodeRootPath = false;
    private String accessKey;
    private String secretKey;
    boolean debug = false;

    public OpenApiClientHttpClient(String host, String accessKey, String secretKey, boolean debug) {
        this.httpClientConfig = HttpClientConfig.getDefault();
        if (StringUtils.isEmpty((String)host) || StringUtils.isEmpty((String)accessKey) || StringUtils.isEmpty((String)secretKey)) {
            throw new IllegalArgumentException("init OpenAPIClien failed for illegal argument");
        }
        this.host = host;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.debug = debug;
    }

    public OpenApiClientHttpClient(String host, String rootPath, boolean encodeRootPath, String accessKey, String secretKey, boolean debug) {
        this.httpClientConfig = HttpClientConfig.getDefault();
        if (StringUtils.isEmpty((String)host) || StringUtils.isEmpty((String)accessKey) || StringUtils.isEmpty((String)secretKey)) {
            throw new IllegalArgumentException("init OpenAPIClien failed for illegal argument");
        }
        if (encodeRootPath && StringUtils.isEmpty((String)rootPath)) {
            throw new IllegalArgumentException("init OpenAPIClien failed for illegal argument");
        }
        this.host = host;
        this.rootPath = rootPath;
        this.encodeRootPath = encodeRootPath;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.debug = debug;
    }

    public OpenApiClientHttpClient(HttpClientConfig config, String host, String accessKey, String secretKey, boolean debug) {
        super(config);
        if (StringUtils.isEmpty((String)host) || StringUtils.isEmpty((String)accessKey) || StringUtils.isEmpty((String)secretKey)) {
            throw new IllegalArgumentException("init OpenAPIClien failed for illegal argument");
        }
        this.host = host;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.debug = debug;
    }

    public OpenApiClientHttpClient(HttpClientConfig config, String host, String rootPath, boolean encodeRootPath, String accessKey, String secretKey, boolean debug) {
        super(config);
        if (StringUtils.isEmpty((String)host) || StringUtils.isEmpty((String)accessKey) || StringUtils.isEmpty((String)secretKey)) {
            throw new IllegalArgumentException("init OpenAPIClien failed for illegal argument");
        }
        if (encodeRootPath && StringUtils.isEmpty((String)rootPath)) {
            throw new IllegalArgumentException("init OpenAPIClien failed for illegal argument");
        }
        this.host = host;
        this.rootPath = rootPath;
        this.encodeRootPath = encodeRootPath;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.debug = debug;
    }

    @Override
    public String syncExecute(HttpRequest request) throws SDKException {
        this.validataHttpRequest(request);
        try {
            HttpRequest newRequest = this.signRequest(request);
            HttpResponse response = this.syncInvoke(newRequest);
            return this.parseHttpResponse(request.getUri(), response);
        }
        catch (IOException e) {
            throw new ClientException("request error, url: " + request.getUri(), e);
        }
        catch (IllegalArgumentException e) {
            throw new ClientException("request error, parameter error", e);
        }
    }

    @Override
    public String asyncExecute(HttpRequest request) throws SDKException {
        this.validataHttpRequest(request);
        HttpRequest newRequest = this.signRequest(request);
        try {
            Future<HttpResponse> future = this.asyncInvoke(newRequest);
            HttpResponse response = future.get();
            return this.parseHttpResponse(request.getUri(), response);
        }
        catch (InterruptedException e) {
            throw new ClientException("failed to request: url:" + request.getUri(), e);
        }
        catch (ExecutionException e) {
            throw new ClientException("failed to request: url:" + request.getUri(), e);
        }
    }

    @Override
    public <T> T syncExecute(HttpRequest request, Class<T> object) throws SDKException {
        return (T)JSONObject.parseObject((String)this.syncExecute(request), object);
    }

    @Override
    public <T> T asyncExecute(HttpRequest request, Class<T> object) throws SDKException {
        return (T)JSONObject.parseObject((String)this.asyncExecute(request), object);
    }

    private void validataHttpRequest(HttpRequest request) throws ClientException {
        if (null == request) {
            throw new ClientException("input parameter can not be null");
        }
        if (null == request.getUri()) {
            throw new ClientException("parameter error, uri can not be null");
        }
    }

    private String parseHttpResponse(String uri, HttpResponse response) throws ClientException {
        if (response.getCode() != 200) {
            String errorMsg = String.format("failed to request: url: %s, http_code: %s", uri, response.getCode());
            OpenAPILoggerUtils.error((String)errorMsg);
            throw new ClientException(errorMsg);
        }
        JSONObject jsonObject = JSONObject.parseObject((String)response.getResponse());
        String traceId = jsonObject.getString("traceId");
        String errorCode = jsonObject.getString("code");
        String errorMessgae = jsonObject.getString("message");
        boolean success = jsonObject.getBoolean("success");
        String data = jsonObject.getString("data");
        if (!success) {
            throw new ClientException(traceId, errorCode, errorMessgae);
        }
        if (this.debug) {
            this.printDebugInfo(traceId, response);
        }
        return data;
    }

    private void printDebugInfo(String traceId, HttpResponse response) {
        if (this.debug && response.getHeaders().size() > 0 && response.getHeaders().containsKey("R-Gw-Signatured") && response.getHeaders().containsKey("R-Gw-String-To-Sign")) {
            String serverStringToSign = response.getHeaders().get("R-Gw-String-To-Sign");
            String serverSignature = response.getHeaders().get("R-Gw-Signatured");
            String info = String.format("server return debug info: \n traceId: %s, \n string_to_sign: %s \n signature: %s \n", traceId, serverStringToSign, serverSignature);
            OpenAPILoggerUtils.info((String)info);
        }
    }

    private HttpRequest signRequest(HttpRequest request) {
        HashMap<String, String> signHeaders = new HashMap<String, String>();
        signHeaders.put("X-Gw-AccessId", this.accessKey);
        signHeaders.put("X-Gw-Nonce", UUID.randomUUID().toString());
        signHeaders.put("X-Gw-Timestamp", String.valueOf(System.currentTimeMillis()));
        if (request.getHeaders() != null && request.getHeaders().containsKey("X-Gw-ExtHeaders") && request.getHeaders().get("X-Gw-ExtHeaders") != null) {
            for (String header : request.getHeaders().get("X-Gw-ExtHeaders").split(",")) {
                if (null == request.getHeaders().get(header)) {
                    String msg = String.format("request error, a header %s is specified in Header: %s, but can not found in headers", header, "X-Gw-ExtHeaders");
                    throw new IllegalArgumentException(msg);
                }
                signHeaders.put(header, request.getHeaders().get(header));
            }
        }
        Map<String, String> signParameters = null;
        if (!request.getMethod().isHasContent() || this.isFormFormat(request)) {
            signParameters = ParameterUtil.getFormMap(request.getParameters());
        }
        if (this.isFormFormat(request)) {
            request.addHeader("Content-Type", FormatType.FORM.format);
        }
        String signatureUri = this.buildSignatureURI(request.getUri());
        String stringToSign = SignatureUtil.buildStringToSign((String)signatureUri, (String)request.getMethod().name(), signParameters, signHeaders);
        String signature = SignatureUtil.sign((String)stringToSign, (String)this.secretKey);
        signHeaders.put("X-Gw-Signature", signature);
        String url = this.buildURL(request.getUri());
        request.setUri(url);
        request.getHeaders().putAll(signHeaders);
        return request;
    }

    private boolean isFormFormat(HttpRequest request) {
        if (request.getHttpContentType() == FormatType.FORM) {
            return true;
        }
        Map<String, String> headerMap = request.getHeaders();
        if (headerMap == null || headerMap.size() < 1) {
            return false;
        }
        for (String key : headerMap.keySet()) {
            if (!key.toLowerCase().contains(FormatType.FORM.format)) continue;
            return true;
        }
        return false;
    }

    private String buildURL(String uri) {
        StringBuilder sb = new StringBuilder();
        if (this.host.endsWith("/")) {
            sb.append(this.host.substring(0, this.host.length() - 1));
        } else {
            sb.append(this.host);
        }
        if (StringUtils.isNotEmpty((String)this.rootPath)) {
            if (!this.rootPath.startsWith("/")) {
                sb.append("/");
            }
            if (!this.rootPath.endsWith("/")) {
                sb.append(this.rootPath);
            } else {
                sb.append(this.rootPath.substring(0, this.rootPath.length() - 1));
            }
        }
        if (!uri.startsWith("/")) {
            sb.append("/");
        }
        if (uri.endsWith("/")) {
            sb.append(uri.substring(0, uri.length() - 1));
        } else {
            sb.append(uri);
        }
        return sb.toString();
    }

    private String buildSignatureURI(String uri) {
        if (!this.encodeRootPath) {
            return uri.startsWith("/") ? uri : "/" + uri;
        }
        StringBuilder sb = new StringBuilder();
        if (!this.rootPath.startsWith("/")) {
            sb.append("/");
        }
        if (!this.rootPath.endsWith("/")) {
            sb.append(this.rootPath);
        } else {
            sb.append(this.rootPath.substring(0, this.rootPath.length() - 1));
        }
        if (!uri.startsWith("/")) {
            sb.append("/");
        }
        if (uri.endsWith("/")) {
            sb.append(uri.substring(0, uri.length() - 1));
        } else {
            sb.append(uri);
        }
        return sb.toString();
    }
}

