/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.quickbi.openapi.client;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.quickbi.openapi.client.ApacheIdleConnectionCleaner;
import com.alibaba.quickbi.openapi.client.CompositeX509TrustManager;
import com.alibaba.quickbi.openapi.client.FormatType;
import com.alibaba.quickbi.openapi.client.HttpRequest;
import com.alibaba.quickbi.openapi.client.HttpResponse;
import com.alibaba.quickbi.openapi.client.IHttpClient;
import com.alibaba.quickbi.openapi.client.ParameterUtil;
import com.alibaba.quickbi.openapi.core.config.HttpClientConfig;
import com.alibaba.quickbi.openapi.core.exception.ClientException;
import com.alibaba.quickbi.openapi.core.util.StringUtils;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class AbstractHttpClient
extends IHttpClient {
    private ExecutorService executorService;
    private CloseableHttpClient httpClient;
    private PoolingHttpClientConnectionManager connectionManager;
    private volatile AtomicBoolean inited = new AtomicBoolean(false);
    private CountDownLatch latch = new CountDownLatch(1);

    public AbstractHttpClient() {
    }

    public AbstractHttpClient(HttpClientConfig config) {
        super(config);
    }

    @Override
    public void init(final HttpClientConfig clientConfig) throws ClientException {
        if (!this.inited.compareAndSet(false, true)) {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                throw new ClientException("init httpclient failed", e);
            }
            return;
        }
        HttpClientBuilder builder = HttpClientBuilder.create();
        this.httpClientConfig = clientConfig;
        RequestConfig defaultConfig = RequestConfig.custom().setConnectTimeout(this.httpClientConfig.getConnectionTimeoutMillis()).setSocketTimeout(this.httpClientConfig.getReadTimeoutMillis()).setConnectionRequestTimeout(this.httpClientConfig.getWriteTimeoutMillis()).build();
        builder.setDefaultRequestConfig(defaultConfig);
        this.initConnectionManager();
        builder.setConnectionManager((HttpClientConnectionManager)this.connectionManager);
        ApacheIdleConnectionCleaner.registerConnectionManager((HttpClientConnectionManager)this.connectionManager, Long.valueOf(this.httpClientConfig.getMaxIdleTimeMillis()));
        this.initExecutor();
        if (clientConfig.getKeepAliveDurationMillis() > 0) {
            builder.setKeepAliveStrategy(new ConnectionKeepAliveStrategy(){

                public long getKeepAliveDuration(org.apache.http.HttpResponse response, HttpContext context) {
                    long duration = DefaultConnectionKeepAliveStrategy.INSTANCE.getKeepAliveDuration(response, context);
                    if (duration > 0L && duration < (long)clientConfig.getKeepAliveDurationMillis()) {
                        return duration;
                    }
                    return clientConfig.getKeepAliveDurationMillis();
                }
            });
        }
        this.httpClient = builder.build();
        this.latch.countDown();
    }

    /*
     * WARNING - void declaration
     */
    private HttpUriRequest parseToHttpRequest(HttpRequest request) throws URISyntaxException {
        RequestBuilder builder = RequestBuilder.create((String)request.getMethod().name());
        URIBuilder uriBuilder = new URIBuilder(request.getUri());
        if (!request.getMethod().isHasContent() && null != request.getParameters() && request.getParameters().size() > 0) {
            for (String string : request.getParameters().keySet()) {
                Object o = request.getParameters().get(string);
                String param = null;
                param = o instanceof String ? (String)o : JSONObject.toJSONString((Object)o);
                uriBuilder.addParameter(string, param);
            }
        }
        builder.setUri(uriBuilder.build());
        if (request.getMethod().isHasContent() && null != request.getParameters() && request.getParameters().size() > 0) {
            void var5_8;
            EntityBuilder bodyBuilder = EntityBuilder.create();
            String string = request.getHeaders().get("Content-Type");
            if (StringUtils.isEmpty((String)string)) {
                String string2 = ContentType.APPLICATION_JSON.toString();
            }
            String entity = null;
            if (FormatType.getFormType((String)var5_8) == FormatType.JSON) {
                entity = ParameterUtil.getJsonData(request.getParameters());
            } else if (FormatType.getFormType((String)var5_8) == FormatType.FORM) {
                entity = ParameterUtil.getFormData(request.getParameters());
            }
            bodyBuilder.setContentType(ContentType.parse((String)var5_8));
            bodyBuilder.setText(entity);
            bodyBuilder.setContentEncoding("UTF-8");
            builder.setEntity(bodyBuilder.build());
        }
        builder.addHeader("Accept-Encoding", "identity");
        for (Map.Entry entry : request.getHeaders().entrySet()) {
            if ("Content-Length".equalsIgnoreCase((String)entry.getKey())) continue;
            builder.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        return builder.build();
    }

    private void initConnectionManager() throws ClientException {
        RegistryBuilder socketFactoryRegistryBuilder = RegistryBuilder.create();
        socketFactoryRegistryBuilder.register("http", (Object)new PlainConnectionSocketFactory());
        SSLConnectionSocketFactory sslConnectionSocketFactory = this.createSSLConnectionSocketFactory();
        socketFactoryRegistryBuilder.register("https", (Object)sslConnectionSocketFactory);
        this.connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistryBuilder.build());
        this.connectionManager.setMaxTotal(this.httpClientConfig.getMaxRequests());
        this.connectionManager.setDefaultMaxPerRoute(this.httpClientConfig.getMaxRequestsPerHost());
    }

    private SSLConnectionSocketFactory createSSLConnectionSocketFactory() throws ClientException {
        try {
            ArrayList<TrustManager> trustManagerList = new ArrayList<TrustManager>();
            X509TrustManager[] trustManagers = this.httpClientConfig.getX509TrustManagers();
            if (null != trustManagers) {
                trustManagerList.addAll(Arrays.asList(trustManagers));
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init((KeyStore)null);
            trustManagerList.addAll(Arrays.asList(tmf.getTrustManagers()));
            ArrayList<X509TrustManager> finalTrustManagerList = new ArrayList<X509TrustManager>();
            for (TrustManager tm : trustManagerList) {
                if (!(tm instanceof X509TrustManager)) continue;
                finalTrustManagerList.add((X509TrustManager)tm);
            }
            CompositeX509TrustManager compositeX509TrustManager = new CompositeX509TrustManager(finalTrustManagerList);
            compositeX509TrustManager.setIgnoreSSLCert(this.httpClientConfig.isIgnoreSSLCerts());
            KeyManager[] keyManagers = null;
            if (this.httpClientConfig.getKeyManagers() != null) {
                keyManagers = this.httpClientConfig.getKeyManagers();
            }
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, new TrustManager[]{compositeX509TrustManager}, this.httpClientConfig.getSecureRandom());
            Object hostnameVerifier = null;
            hostnameVerifier = this.httpClientConfig.isIgnoreSSLCerts() ? new NoopHostnameVerifier() : (this.httpClientConfig.getHostnameVerifier() != null ? this.httpClientConfig.getHostnameVerifier() : new DefaultHostnameVerifier());
            SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostnameVerifier);
            return sslConnectionSocketFactory;
        }
        catch (Exception e) {
            throw new ClientException("Init https with SSL socket failed", e);
        }
    }

    private void initExecutor() {
        if (null == this.executorService) {
            this.executorService = new ThreadPoolExecutor(0, this.httpClientConfig.getMaxRequests(), 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DefaultAsyncThreadFactory());
        }
    }

    @Override
    public HttpResponse syncInvoke(HttpRequest request) throws IOException, ClientException {
        CloseableHttpResponse response = null;
        try {
            HttpUriRequest httpRequest = this.parseToHttpRequest(request);
            response = this.httpClient.execute(httpRequest);
            int code = response.getStatusLine().getStatusCode();
            String responseStr = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            HttpResponse result = new HttpResponse();
            result.setCode(code);
            result.setResponse(responseStr);
            HashMap<String, String> headers = new HashMap<String, String>();
            for (Header header : response.getAllHeaders()) {
                headers.put(header.getName(), header.getValue());
            }
            result.setHeaders(headers);
            HttpResponse httpResponse = result;
            return httpResponse;
        }
        catch (URISyntaxException e) {
            throw new ClientException("request error, url :" + request.getUri(), e);
        }
        catch (ClientProtocolException e) {
            throw new ClientException("request error, url :" + request.getUri(), e);
        }
        catch (IOException e) {
            throw new ClientException("request error, url :" + request.getUri(), e);
        }
        finally {
            if (null != response) {
                response.close();
            }
        }
    }

    @Override
    public Future<HttpResponse> asyncInvoke(final HttpRequest request) {
        return this.executorService.submit(new Callable<HttpResponse>(){

            @Override
            public HttpResponse call() throws Exception {
                return AbstractHttpClient.this.syncInvoke(request);
            }
        });
    }

    @Override
    public void close() throws IOException {
        if (this.inited.compareAndSet(true, false)) {
            this.executorService.shutdown();
            ApacheIdleConnectionCleaner.removeConnectionManager((HttpClientConnectionManager)this.connectionManager);
            this.connectionManager.shutdown();
            this.httpClient.close();
        }
    }

    private class DefaultAsyncThreadFactory
    implements ThreadFactory {
        private AtomicInteger counter = new AtomicInteger(0);

        private DefaultAsyncThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, "QuickBI_OpenApi_SDK_Thread_" + this.counter.incrementAndGet());
        }
    }
}

