/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.quickbi.openapi;

import com.alibaba.quickbi.openapi.client.IOpenAPIClient;
import com.alibaba.quickbi.openapi.client.OpenApiClientHttpClient;
import com.alibaba.quickbi.openapi.core.config.HttpClientConfig;
import com.alibaba.quickbi.openapi.core.exception.ClientException;

public class HttpClientFactory {
    public static IOpenAPIClient buildDefaultClient(String host, String ak, String sk, boolean debug) {
        return HttpClientFactory.buildClient(host, null, false, ak, sk, HttpClientConfig.getDefault(), debug);
    }

    public static IOpenAPIClient buildDefaultClient(String host, String rootPath, boolean encodeRootPath, String ak, String sk, boolean debug) {
        return HttpClientFactory.buildClient(host, rootPath, encodeRootPath, ak, sk, HttpClientConfig.getDefault(), debug);
    }

    public static IOpenAPIClient buildClient(String host, String rootPath, boolean encodeRootPath, String ak, String sk, HttpClientConfig httpClientConfig, boolean debug) {
        if (null == host || null == ak || null == sk) {
            throw new IllegalArgumentException("can not init client, host/ak/sk can not be null");
        }
        OpenApiClientHttpClient client = new OpenApiClientHttpClient(httpClientConfig, host, rootPath, encodeRootPath, ak, sk, debug);
        try {
            client.init(httpClientConfig);
            return client;
        }
        catch (ClientException e) {
            throw new IllegalStateException("init http client failed", e);
        }
    }
}

