package com.bizvane.mktcenterservice.models.newmkt;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.*;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @author Ljc
 */

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class ActivityConfigVO implements Serializable {

    private static final long serialVersionUID = 1L;
    /**
     * 活动模块主键id
     */
    private Integer id;
    /**
     * 活动模块名称
     */
    private String name;
    /**
     * 活动模块描述
     */
    private String description;

    /**
     * 创建时间yyyy-MM-dd HH:mm:ss
     */
    @DateTimeFormat(
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date createTime;

    /**
     * 更新时间yyyy-MM-dd HH:mm:ss
     */
    @DateTimeFormat(
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date updateTime;

    /**
     * 活动类型 满元: OD_MONEY
     */
    private String activityType;

    /**
     * 该活动模块是否在页面展示 显示:1 不显示:0
     */
    private Integer isDisplay;

}
