package com.bizvane.mktcenterservice.models.vo;

import com.alibaba.fastjson.JSON;
import com.bizvane.centerstageservice.models.po.SysDimSkuPo;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.centerstageservice.models.vo.SelectCacheKeyVo;
import com.bizvane.members.facade.models.MbrGroupModel;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
public class TaskInfoVO {


    @ApiModelProperty(value = "任务")
    private TaskVO taskVO;

    private MbrGroupModel mbrGroupModel;

    /**
     * 券定义列表
     */
    private List<Long> mktCouponDefinitionList;
    private MktGiftBagVO mktGiftBag;

    /**
     * 受邀者奖励券号列表
     */
    private List<Long> mktInviteeCouponDefinitionList;
    private MktGiftBagVO mktInviteGiftBag;

    /**
     * 邀请人订单奖励优惠券列表
     */
    private List<Long> mktInviteOrderCouponDefinitionList;
    private MktGiftBagVO mktInviteOrderGiftBag;


    @Data
    public static class MktGiftBagVO {
        @io.swagger.annotations.ApiModelProperty(value = "券定义ID集合")
        private List<Long> couponDefinitionIdList;
        @io.swagger.annotations.ApiModelProperty(value = "权益ID")
        private Long mktGiftBagId;
        @io.swagger.annotations.ApiModelProperty(value = "权益编号")
        private String mktGiftBagCode;
        @io.swagger.annotations.ApiModelProperty(value = "权益名称")
        private String mktGiftBagName;
        @io.swagger.annotations.ApiModelProperty(value = "赠送积分")
        private Integer points;

    }
}
