package com.bizvane.mktcenterservice.models.newmkt;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.springframework.data.elasticsearch.core.SearchResultMapper;

import java.io.Serializable;
import java.util.Date;

/**
 * @description:
 * @author: Liu Xinpeng
 * @create: 2020-08-18 19:33
 **/

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class MktMessageCommonPo implements Serializable {
    private static final long serialVersionUID = 1L;


    /**
     * 消息编号
     */
    private Long mktMsgId;

    /**
     * 企业id
     */
    private Long sysCompanyId;


    /**
     * 消息业务类型：1活动，2任务.
     */
    private Integer bizType;

    /**
     * 业务单号
     */
    private Long bizId;

    /**
     * 消息类型，1模板消息，2短信,3图文消息
     */
    private String msgType;


    /**
     * 消息编号
     */
    private String msgCode;

    /**
     * 消息模板id
     */
    private String templateMsgId;

    /**
     * 国内消息模板编号
     */
    private String templateCodeCn;


    /**
     * 国际模板编号
     */
    private String templateCodeIntl;


    /**
     * 是否立即发送
     */
    private Boolean sendImmediately;


    /**
     * 开始发送时间
     */
    private Date sendTime;


    /**
     * 头内容或首标语
     */
    private String first;

    /**
     * 消息的具体详情
     */
    private String msgTail;

    /**
     * 1=会员中心  2=h5.
     */
    private Integer urlType;

    /**
     * 链接地址(微信模板链接)
     */
    private String link;


    /**
     * 消息发送是否排除微信会员，1是，0否
     */
    private Boolean exceptWechat;
    /**
     * 备注
     */
    private String remark;


    /**
     * 导航语
     */
    private String navigation;


    /**
     * 活动时间（定向运行和智能营销模板消息的字段
     */
    private String activityTime;

    /**
     * 赞助商
     */
    private String sponsor;

    /**
     * 创建人id
     */
    private Long createUserId;


    /**
     * 创建人
     */
    private String createUserName;

    /**
     * 创建日期
     */
    private Date createDate;

    /**
     * 修改人id
     */
    private Long modifiedUserId;

    /**
     * 修改人
     */
    private String modifiedUserName;

    /**
     * 修改时间
     */
    private Date modifiedDate;


    /**
     * 数据有效性：1=有效；0=无效
     */
    private Boolean valid;

    /**
     * 消息内容     */
    private String msgContent;

}