package com.bizvane.mktcenterservice.rpc.cert;

import com.bizvane.mktcenterservice.models.vo.tree3.reqvo.*;
import com.bizvane.mktcenterservice.models.vo.tree3.respvo.*;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

@ApiModel(value = "认证活动远程调用接口")
@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/mktActivityCertificationRpc")
public interface MktActivityCertificationFeignRpc {

    @ApiOperation(value = "认证类型列表查询")
    @PostMapping("/getCertificationTypePage")
    ResponseData<PageInfo<SelectPageCertificationTypeRespVO>> getCertificationTypePage(@RequestBody SelectPageCertificationTypeReqVO reqVO);


    @ApiOperation(value = "认证活动列表查询")
    @PostMapping("/getMktCertificationPage")
    ResponseData<PageInfo<SelectPageActivityCertificationRespVO>> getMktCertificationPage(@RequestBody SelectPageActivityCertificationReqVO reqVO);


    @ApiOperation(value = "认证活动详情查询")
    @PostMapping("/getMktCertificationDetail")
    ResponseData<GetDetailActivityCertificationRespVO> getMktCertificationDetail(@RequestParam Long mktActivityCertificationId,@RequestParam String memberCode,@RequestParam Long sysCompanyId,@RequestParam Long sysBrandId);


    @ApiOperation(value = "认证活动会员报名信息查询")
    @PostMapping("/getCertificationMemberInfo")
    ResponseData<MktActivityCertificationRecordVo> getCertificationMemberInfo(@RequestParam String memberCode, @RequestParam Long sysCompanyId, @RequestParam Long sysBrandId);


    @ApiOperation(value = "OCR识别身份证信息")
    @PostMapping("/ocrIdCard")
    ResponseData<Map<String,Object>> ocrIdCard(@RequestParam String portraitUrl, @RequestParam String nationalUrl);


    @ApiOperation(value = "认证活动保存、修改报名信息")
    @PostMapping("/saveOrModifyMktCertificationRecord")
    ResponseData<Boolean> saveOrModifyMktCertificationRecord(@RequestBody MktActivityCertificationRecordVo reqVO);


    @ApiOperation(value = "认证活动签到")
    @PostMapping("/signInMktCertification")
    ResponseData<Boolean> signInMktCertification(@RequestParam Long mktActivityCertificationRecordId,@RequestParam String memberCode,@RequestParam Long sysCompanyId,@RequestParam Long sysBrandId);



    @ApiOperation(value = "我的认证信息和证书列表查询")
    @PostMapping("/getCertificationInfo")
    ResponseData<GetCertificationInfoRespVO> getCertificationInfo(@RequestParam String memberCode, @RequestParam Long sysCompanyId, @RequestParam Long sysBrandId);


    @ApiOperation(value = "施工能力列表查询")
    @PostMapping("/queryConstructabilityPage")
    ResponseData<PageInfo<SelectPageConstructabilityRespVO>> queryConstructabilityPage(@RequestBody SelectPageConstructabilityReqVO reqVO);


    @ApiOperation(value = "认证类型列表查询")
    @GetMapping("/getCertTypeList")
    ResponseData<List<GetDetailCertificationTypeRespVO>> getCertTypeList(@RequestParam("sysCompanyId") Long sysCompanyId, @RequestParam("sysBrandId") Long sysBrandId);

    @ApiOperation(value = "认证师傅分页列表查询")
    @PostMapping("/queryCertMembersPageList")
    ResponseData<PageInfo<GetCertificationInfoRespVO>> queryCertMembersPageList(@RequestBody SelectPageCertMembersReqVO reqVO);


    @ApiOperation(value = "查询培训认证宣传文案")
    @PostMapping("/getCertInfo")
    ResponseData<GetSysCertInfoRespVO> getCertInfo(@RequestParam("sysCompanyId") Long sysCompanyId, @RequestParam("sysBrandId") Long sysBrandId);
}
