package com.bizvane.mktcenterservice.models.vo;

import java.util.Date;

import lombok.Data;

@Data
public class MemberTaskPrizeResVO {
    /**
     * 奖品记录ID
     */
    private Long id;
    /**
     * 奖品类型(1.积分,2.优惠券,3.实物奖品)
     */
    private Integer type;
    /**
     * 奖品名称
     */
    private String name;
    /**
     * 获奖时间
     */
    private Date awardTime;
    /**
     * 奖品图片
     */
    private String imageUrl;
    /**
     * 优惠券状态
     */
    private Integer couponStatus;
    /**
     * 实物提货方式：0.物流配送 1.门店自提
     */
    private Integer extractionType;
    /**
     * 实物奖品状态(0.未填写提货方式及信息,1.已填写提货方式及信息,2.已发货/已提货)
     */
    private Integer prizeStatus;
    /**
     * 收获信息
     */
    private TaskPrizeLinkmanVO linkmanVO;
    /**
     * 提货店铺信息
     */
    private PickUpStoreVO storeVO;
}
