package com.bizvane.mktcenterservice.models.vo.tree3.respvo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@Data
public class SelectPageActivityCertificationRespVO {

    @ApiModelProperty("认证活动Id")
    private Long mktActivityCertificationId;

    private Long sysCompanyId;

    private Long sysBrandId;

    @ApiModelProperty("认证活动名称")
    private String activityName;

    @ApiModelProperty("认证活动开始时间")
    private Date startTime;

    @ApiModelProperty("认证活动结束时间")
    private Date endTime;

    @ApiModelProperty("认证活动状态(1-活动中 2-已结束)")
    private Integer state;

    @ApiModelProperty(value = "报名二维码")
    private String applyQrCode;

    @ApiModelProperty(value = "签到二维码")
    private String signInQrCode;

    @ApiModelProperty(value = "省")
    private String province;

    @ApiModelProperty(value = "市")
    private String city;

    @ApiModelProperty(value = "区")
    private String district;

    @ApiModelProperty(value = "详细地址")
    private String detailedAddress;

    @ApiModelProperty(value = "经度")
    private String addressLon;

    @ApiModelProperty(value = "纬度")
    private String addressLat;

    @ApiModelProperty(value = "活动图片")
    private String activityImg;

    private String onlineOrgCode;

    private String onlineOrgName;

    private Long createUserId;

    private String createUserName;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createDate;

    private Long modifiedUserId;

    private String modifiedUserName;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date modifiedDate;
}
