package com.bizvane.mktcenterservice.models.vo.tree3.reqvo;

import com.bizvane.mktcenterservice.models.vo.PageForm;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class LearnCourseRecordQueryRequestVO extends PageForm {

    @NotNull(message = "课程PKID不允许为空")
    @ApiModelProperty(value = "课程PKID", name = "mktLearnCourseId")
    private Long mktLearnCourseId;

    @ApiModelProperty(value = "品牌id", name = "brandId")
    private Long sysCompanyId;

    @ApiModelProperty(value = "品牌id", name = "brandId")
    private Long sysBrandId;

    @ApiModelProperty(value = "会员手机号", name = "phone")
    private String phone;

    @ApiModelProperty(value = "课程-学习状态 0浏览 1学习中 2已完成", name = "learnStatus")
    private Integer learnStatus;

    @ApiModelProperty(value = "评分 最高5星", name = "star")
    private Integer star;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date exchangeDateStart;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date exchangeDateEnd;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date completeTimeStart;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date completeTimeEnd;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date commentTimeStart;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date commentTimeEnd;

}
