package com.bizvane.mktcenterservice.models.po;

import lombok.Data;
import java.io.Serializable;
import java.util.Date;

@Data
public class MktTaskPhysicalPO implements Serializable {
    private static final long serialVersionUID = 1L;

    @io.swagger.annotations.ApiModelProperty(value = "pkid", name = "mktTaskPhysicalId", required = false, example = "")
    private Long mktTaskPhysicalId;

    @io.swagger.annotations.ApiModelProperty(value = "企业id", name = "sysCompanyId", required = false, example = "")
    private Long sysCompanyId;

    @io.swagger.annotations.ApiModelProperty(value = "关联任务id", name = "bizId", required = false, example = "")
    private Long mktTaskId;

    @io.swagger.annotations.ApiModelProperty(value = "实物奖品图片url", name = "physicalImage", required = false, example = "")
    private String physicalImage;

    @io.swagger.annotations.ApiModelProperty(value = "实物奖品名称", name = "physicalName", required = false, example = "")
    private String physicalName;

    @io.swagger.annotations.ApiModelProperty(value = "实物提货方式：0.物流配送 1.门店自提", name = "physicalExtractionType", required = false, example = "")
    private Integer physicalExtractionType;

    @io.swagger.annotations.ApiModelProperty(value = "门店范围类型：0.全部门店 1.指定门店，2.服务门店", name = "storeScopeType", required = false, example = "")
    private Integer storeScopeType;

    @io.swagger.annotations.ApiModelProperty(value = "门店范围ID：门店CODE字符串逗号拼接", name = "storeScopeIds", required = false, example = "")
    private String storeScopeIds;

    @io.swagger.annotations.ApiModelProperty(value = "备注", name = "remark", required = false, example = "")
    private String remark;

    @io.swagger.annotations.ApiModelProperty(value = "创建人id", name = "createUserId", required = false, example = "")
    private Long createUserId;

    @io.swagger.annotations.ApiModelProperty(value = "创建人", name = "createUserName", required = false, example = "")
    private String createUserName;

    @io.swagger.annotations.ApiModelProperty(value = "创建日期", name = "createDate", required = false, example = "")
    private Date createDate;

    @io.swagger.annotations.ApiModelProperty(value = "修改人id", name = "modifiedUserId", required = false, example = "")
    private Long modifiedUserId;

    @io.swagger.annotations.ApiModelProperty(value = "修改人", name = "modifiedUserName", required = false, example = "")
    private String modifiedUserName;

    @io.swagger.annotations.ApiModelProperty(value = "修改时间", name = "modifiedDate", required = false, example = "")
    private Date modifiedDate;

    @io.swagger.annotations.ApiModelProperty(value = "数据有效性：1=有效；0=无效", name = "valid", required = false, example = "")
    private Boolean valid;
}