package com.bizvane.mktcenterservice.models.newmkt;

import com.bizvane.mktcenterservice.models.po.MktMessagePO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;

/**
 * @description: 发送消息的简化版实体
 * @author: Liu Xinpeng
 * @create: 2020-08-18 19:55
 **/
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class SimpleMessage implements Serializable {

    private static final long serialVersionUID = 1L;
    /**
     * 子商户号
     */
    private String subMerchantId;

    /**
     * 企业id
     */
    private Long sysCompanyId;

    /**
     * 品牌id
     */
    private Long sysBrandId;

    /**
     * 业务单号id
     */
    private Long bizId;




    /**
     * 活动编号
     */
    private String activityCode;


    /**
     * 活动名称
     */
    private String taskName;

    /**
     * 活动类型
     */
    private Integer taskType;

    /**
     * 通知类型
     * ALL 都通知
     * WECHAT_NOTIFY:微信通知
     * MESSAGE_NOTIFY:短信通知 
     * NONE:都不通知  
     */
    private String notifyType;


    /**
     * 创建人名字
     */
    private String createUserName;

    /**
     * 发送时间
     */
    private Date sendTime;

    /**
     * 会员信息
     */
    private MktMemActivityGroupVO userGroupIds;

    /**
     * 店铺信息
     */
    private MktMemActivityGroupVO storeGroup;
}