package com.bizvane.mktcenterservice.interfaces.newmkt;

import com.bizvane.centerstageservice.models.po.SysCheckPo;
import com.bizvane.mktcenterservice.models.newmkt.*;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * @author ljc
 * @date on 2020/8/4 11:28
 */
public interface ActivityMemberService {

    /**
     * 查询活动模块接口
     * @param sysAccountPo
     * @return
     */
    ResponseData<List<ActivityConfigVO>> findActivityConfig(SysAccountPO sysAccountPo);

    /**
     * 查询活动列表
     * @param requestVo
     * @param sysAccountPo
     * @return
     */
    ResponseData<PageInfo<ActivityPageResponseVO>> getActivityList(ActivityPageRequestVO requestVo, SysAccountPO sysAccountPo);

    /**
     * 查询单个活动详情
     * @param activityCode
     * @param isCheckMerchant
     * @param sysAccountPo
     * @return
     */
    ResponseData<ActivityPageResponseVO> getActivityDetail(String activityCode, Boolean isCheckMerchant, SysAccountPO sysAccountPo);

    /**
     * 审核新营销
     * @param po
     * @param sysAccountPo
     * @return
     */
    ResponseData checkActivity(SysCheckPo po, SysAccountPO sysAccountPo);


    /**
     * 关闭活动
     * @param activityCode
     * @param sysAccountPo
     * @return
     */
    ResponseData disableActivity(String activityCode, SysAccountPO sysAccountPo);

    /**
     * 暂停/开启活动
     * @param activityCode
     * @param status
     * @param sysAccountPo
     * @return
     */
    ResponseData suspendActivity(String activityCode, Long id, String status, SysAccountPO sysAccountPo);

    /**
     * 发送奖励推送mq
     * @param rewardsJson
     * @return
     */
    Boolean sendRewards(String rewardsJson);

    /**
     * 发送奖励mq消费
     * @param vo
     */
    void sendRewardsConsumer(MktMemActivitySendRewardVO vo);

    /**
     * 修改主商户地址
     * @return
     */
    Boolean updateMerchantInfo(Long sysCompanyId, String merchantId, String checkLink, String rewardLink, String notifyLink);
}
