package com.bizvane.mktcenterservice.interfaces;

import com.bizvane.centerstageservice.models.po.SysCheckPo;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.mktcenterservice.models.bo.ActivityBO;
import com.bizvane.mktcenterservice.models.po.MktActivityPOWithBLOBs;
import com.bizvane.mktcenterservice.models.po.MktActivityRecordPO;
import com.bizvane.mktcenterservice.models.po.MktActivitySignin;
import com.bizvane.mktcenterservice.models.vo.*;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.github.pagehelper.PageInfo;

import java.util.Date;
import java.util.List;

/**
 * @author chen.li
 * @date on 2018/7/13 18:44
 * @description
 * @Copyright (c) 2018 上海商帆信息科技有限公司-版权所有
 */
public interface ActivitySigninService {

    /**
     * 查询签到活动列表
     * @param vo
     * @return
     */
    public ResponseData<ActivityVO> getActivitySigninList(ActivityVO vo, PageForm pageForm,SysAccountPO stageUser);
    /**
     * 新增会员签到活动
     * @param bo
     * @return
     */
    public ResponseData<Integer> addActivitySignin(ActivityBO bo, SysAccountPO stageUser);
    /**
     * 查询活动详情
     * @param
     * @return
     */
    @Deprecated
    public ResponseData<ActivityBO> selectActivitySigninById(String businessCode);

    /**
     * 查询签到活动详情
     * @param activityCode
     * @return
     */
    ResponseData<ActivityBO> selectActivitySignInByCode(String activityCode);
    /**
     * 执行活动
     * @param
     * @return
     */
    ResponseData<MktAppletActivitySignInPrizeDetailVO> executeActivitySignin(MktActivitySignMemberVO vo);
    /**
     * 活动审核
     * @param
     * @return
     */
    public ResponseData<Integer> checkActivitySignin(SysCheckPo po, SysAccountPO sysAccountPO);
    /**
     * 查询会员该签到活动是否可参与
     * @param
     * @return
     */
    @Deprecated
    public ResponseData<Boolean> getIsSignAble(MktActivitySignMemberVO vo);

    /**
     * 小程序签到活动奖励规则
     * @param vo
     * @return
     */
    ResponseData<MktAppletActivitySignInPrizeInfoVO> getActivitySignInPrizeInfo(MktActivityRecordVO vo);

    /**
     * 判断会员是否参与签到活动
     * @param vo
     * @return
     */
    ResponseData<Boolean> getIsSignAbleNew(MktActivitySignMemberVO vo);

    /**
     * 获取所有执行中的会员签到活动的品牌集合
     * @return
     */
    ResponseData<List<Long>> getMemberSignOpenSysBrandIds();

    ResponseData<List<ActivityVO>> listActivitySign(ActivityVO vo);

    /**
     * 查询签到活动数据效果分析
     * @param paramsVO
     * @param stageUser
     * @return
     */
    ResponseData<MktActivityAnalysisVO> getSignInActivityAnalysis(MktActivityParamsVO paramsVO,SysAccountPO stageUser);

    /**
     * 查询会员签到活动详情
     * @param paramsVO
     * @param currentUser
     * @return
     */
    ResponseData<MktActivityAnalysisDetailVO> getSignInActivityAnalysisDetail(MktActivityDetailParamsVO paramsVO, SysAccountPO currentUser);

    /**
     * 导出会员签到记录
     * @param paramsVO
     * @param currentUser
     * @return
     */
    ResponseData<Boolean> exportSignInActivityAnalysis(MktActivityDetailParamsVO paramsVO, SysAccountPO currentUser);

    /**
     * 获取会员签到统计
     * @param requestVO
     * @return
     */
    ResponseData<MktActivitySignInDayVO> getSignInDays(MktActivitySignInRequestVO requestVO);

    /**
     * 获取符合会员的会员中心签到活动
     * @param sysBrandId
     * @param memberInfoModel
     * @return
     */
    ActivityVO getFitSignInActivity(Long sysBrandId, MemberInfoModel memberInfoModel);

    /**
     * 获取群签到活动
     * @param sysBrandId
     * @param mktActivityId
     * @return
     */
    ActivityVO getChatSignInActivity(Long sysBrandId, Long mktActivityId);

    /**
     * 根据活动ID获取签到活动信息
     * @param sysCompanyId
     * @param mktActivityId
     * @return
     */
    MktActivitySignin getActivitySignInPOByParams(Long sysCompanyId, Long mktActivityId);

    /**
     * 根据最近的签到记录获取当月一轮次内未领取的连续奖励
     * @param mktActivityRecordPO
     * @param activityPO
     * @param mktActivitySignInId
     * @param memberCode
     * @return
     */
    List<Date> getResidueContinuousDateList(MktActivityRecordPO mktActivityRecordPO, MktActivityPOWithBLOBs activityPO, Long mktActivitySignInId, String memberCode,String monthDate);

    /**
     * 根据最近的签到记录获取当月未领取的累计签到奖励
     * @param mktActivityRecordPO
     * @param activityPO
     * @param mktActivitySignInId
     * @param memberCode
     * @return
     */
    List<Date> getResidueAccumulateDateList(MktActivityRecordPO mktActivityRecordPO, MktActivityPOWithBLOBs activityPO, Long mktActivitySignInId, String memberCode, String monthDate);

    /**
     * 小程序获取会员签到记录奖励
     * @param requestVO
     * @return
     */
    ResponseData<PageInfo<MktAppletActivitySignInRecordVO>> selectSignInRecordInfoPage(MktActivityRecordRequestVO requestVO);

    /**
     * 编辑签到活动
     * @param bo
     * @param stageUser
     * @return
     */
    ResponseData<Integer>  updateActivitySignIn(ActivityBO bo, SysAccountPO stageUser);

}
