package com.bizvane.mktcenterservice.common;

/**
 * @author zcc
 * @date 2020/11/12 15:46
 * 营销类型枚举
 **/
public enum MktTypeDictEnum {
    MKTCENTER_TYPE_ACTIVITY(1, "活动", "mkt_activity_type"),
    MKTCENTER_TYPE_TASK(2, "任务", "mkt_task_type"),
    MKTCENTER_TYPE_GAME(3, "游戏", "mkt_game_type");

    private Integer mktType;
    private String mktTypeName;
    private String mktTypeDictType;

    MktTypeDictEnum(Integer mktType, String mktTypeName, String mktTypeDictType) {
        this.mktType = mktType;
        this.mktTypeName = mktTypeName;
        this.mktTypeDictType = mktTypeDictType;
    }

    public Integer getMktType() {
        return mktType;
    }

    public void setMktType(Integer mktType) {
        this.mktType = mktType;
    }

    public String getMktTypeName() {
        return mktTypeName;
    }

    public void setMktTypeName(String mktTypeName) {
        this.mktTypeName = mktTypeName;
    }

    public String getMktTypeDictType() {
        return mktTypeDictType;
    }

    public void setMktTypeDictType(String mktTypeDictType) {
        this.mktTypeDictType = mktTypeDictType;
    }

    public static MktTypeDictEnum getMktTypeDictEnumByMktType(Integer mktType) {
        for (MktTypeDictEnum mktTypeDictEnum : MktTypeDictEnum.values()) {
            if (mktTypeDictEnum.getMktType().equals(mktType)) {
                return mktTypeDictEnum;
            }
        }
        return null;
    }
}
