package com.bizvane.mktcenterservice.models.vo;

import com.bizvane.members.facade.vo.MbrLevelModelVo;
import com.bizvane.mktcenterservice.models.po.MktActivityPointsLootPoWithBLOBs;
import lombok.Getter;
import lombok.Setter;

import java.util.Date;
import java.util.List;

@Getter
@Setter
public class MktActivityPointsLootVo extends MktActivityPointsLootPoWithBLOBs {



    /**
     * 活动编号
     */
    private String activityCode;

    /**
     * 活动类型
     */
    private Integer activityType;

    /**
     * 审核状态
     */
    private Integer checkStatus;

    /**
     * 活动状态
     */
    //-1不在活动范围内 1:待执行 2:执行中 3:已结束 4:已关闭 5:已取消 6未开奖 7已开奖
    private Integer activityStatus;


    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 会员数量
     */
    private Long mbrNum;

    /**
     *  0:全部门店   1:部分门店   2:圈定会员
     */
    private Integer mbrConditionType;


    private String mbrCondition;

    /**
     * 运营组织
     */
    private String organizationCode;

    /**
     * 实际参与人数
     */
    private Integer actualParticipationNum = 0;
    /**
     * 二维码图片url
     */
    private String qrCodeUrl;
    /**
     * 小程序链接
     */
    private String appletUrl;

    //创建时间开始
    private Date startCreateDate;
    //创建时间结束
    private Date endCreateDate;

    //门店selectKey
    private String storeSelectKey;

    //会员是否参与活动
    private Boolean isParticipateActivity = false;

    //当前时间
    private Date nowDate = new Date();

    //开奖时间
    private Date drawPrizeDate;

    // 开奖失败退还时间
    private Date returnEndDate;

    //会员等级
    private List<MbrLevelModelVo> levelList;

    /**
     * 起始序号
     */
    private Integer startOrderNumber;

    private Date startEndTime;
}
