package com.bizvane.mktcenterservice.models.vo;

import com.alibaba.fastjson.JSON;
import com.bizvane.centerstageservice.models.po.SysDimSkuPo;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.centerstageservice.models.vo.SelectCacheKeyVo;
import com.bizvane.members.facade.models.MbrGroupModel;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
public class TaskInfoVO {


    @ApiModelProperty(value = "任务")
    private TaskVO taskVO;

    private MbrGroupModel mbrGroupModel;

    /**
     * 券定义列表
     */
    private List<Long> mktCouponDefinitionList;
    private MktGiftBagVO mktGiftBag;

    /**
     * 受邀者奖励券号列表
     */
    private List<Long> mktInviteeCouponDefinitionList;
    private MktGiftBagVO mktInviteGiftBag;

    /**
     * 邀请人订单奖励优惠券列表
     */
    private List<Long> mktInviteOrderCouponDefinitionList;
    private MktGiftBagVO mktInviteOrderGiftBag;


    @Data
    public static class MktGiftBagVO {
        @io.swagger.annotations.ApiModelProperty(value = "券定义ID集合")
        private List<Long> couponDefinitionIdList;
        @io.swagger.annotations.ApiModelProperty(value = "权益ID")
        private Long mktGiftBagId;
        @io.swagger.annotations.ApiModelProperty(value = "权益编号")
        private String mktGiftBagCode;
        @io.swagger.annotations.ApiModelProperty(value = "权益名称")
        private String mktGiftBagName;
        @io.swagger.annotations.ApiModelProperty(value = "赠送积分")
        private Integer points;

    }

    public static void main(String[] args) {
        TaskInfoVO taskInfoVO = new TaskInfoVO();
        TaskVO taskVO1 = new TaskVO();
        taskVO1.setTaskInfoType(0);
        taskVO1.setTaskInfo("");
        taskVO1.setTaskListImg("");
        taskVO1.setTaskDetailImg("");
        taskVO1.setDetailShowImg("");
        taskVO1.setInviteNum(0);
        taskVO1.setOrderSource(0);
        taskVO1.setConsumeAmount(new BigDecimal("0"));
        taskVO1.setConsumeTimes(0);
        taskVO1.setPropertyCode("");
        taskVO1.setShareTimes(0);
        taskVO1.setShareUrlType(0);
        taskVO1.setShareUrl("");
        taskVO1.setShowType(0);
        taskVO1.setBrandId(0L);
        taskVO1.setStoreLimitList("");
        taskVO1.setStoreLimitType(0);
        taskVO1.setIsStoreLimit(false);
        taskVO1.setPropertyName("");
        taskVO1.setCouponIsOrNo(false);
        taskVO1.setTemplateCode("");
        taskVO1.setTemplateName("");
        taskVO1.setRewardType(0);
        taskVO1.setMaxInviteNum(0);
        taskVO1.setNewMemberAward(false);
        taskVO1.setNewMemberPoints(0);
        taskVO1.setNewMemberMktGiftBagId(0L);
        taskVO1.setNewMemberCouponIsOrNo(false);
        taskVO1.setInviteOrderAward(false);
        taskVO1.setInviteOrderMinPrice(new BigDecimal("0"));
        taskVO1.setInviteOrderMaxPrice(new BigDecimal("0"));
        taskVO1.setInviteOrderIsCommodityLimit(false);
        taskVO1.setInviteOrderCommodityLimitType(0);
        taskVO1.setInviteOrderCommodityLimitList("");
        taskVO1.setInviteOrderPoints(0);
        taskVO1.setInviteOrderMktGiftBagId(0L);
        taskVO1.setInviteOrderCouponIsOrNo(false);
        SysDimSkuPo sysDimSkuPo = new SysDimSkuPo();
        sysDimSkuPo.setSysDimSkuId(0L);
        sysDimSkuPo.setCorpId("");
        sysDimSkuPo.setSysCompanyId(0L);
        sysDimSkuPo.setSkuId("");
        sysDimSkuPo.setSkuCode("");
        sysDimSkuPo.setProductId("");
        sysDimSkuPo.setProductCode("");
        sysDimSkuPo.setProductName("");
        sysDimSkuPo.setBrandCode("");
        sysDimSkuPo.setSysBrandId(0L);
        sysDimSkuPo.setPriceSug(0.0D);
        sysDimSkuPo.setCostEst(0.0D);
        sysDimSkuPo.setUnit("");
        sysDimSkuPo.setColorPrd("");
        sysDimSkuPo.setColorId("");
        sysDimSkuPo.setColorCode("");
        sysDimSkuPo.setSizePrd("");
        sysDimSkuPo.setSizeId("");
        sysDimSkuPo.setSizeCode("");
        sysDimSkuPo.setYearPrd("");
        sysDimSkuPo.setSeasonPrd("");
        sysDimSkuPo.setCata3Prd("");
        sysDimSkuPo.setCata2Prd("");
        sysDimSkuPo.setCata1Prd("");
        sysDimSkuPo.setTypePrd("");
        sysDimSkuPo.setBandPrd("");
        sysDimSkuPo.setFabelement("");
        sysDimSkuPo.setCreateDate(new Date());
        sysDimSkuPo.setIsSynchron(0);
        sysDimSkuPo.setValid(false);
        sysDimSkuPo.setCata1Code("");
        sysDimSkuPo.setCata2Code("");
        sysDimSkuPo.setCata3Code("");
        sysDimSkuPo.setProperties("");
        sysDimSkuPo.setSpecifications("");
        sysDimSkuPo.setModifiedDate(new Date());
        sysDimSkuPo.setImgUpdateStatus(false);
        sysDimSkuPo.setImg("");
        sysDimSkuPo.setBarCode("");
        sysDimSkuPo.setTimeToMarket(new Date());
        sysDimSkuPo.setLastEsTime(new Date());
        sysDimSkuPo.setProductBrandCode("");
        sysDimSkuPo.setSpecificationJson("");
        sysDimSkuPo.setPropertyJson("");

        taskVO1.setSysDimSkuPos(Lists.newArrayList(sysDimSkuPo));
        taskVO1.setInviteOrderIntegralType(0);
        taskVO1.setInviteOrderIntegralMultiple(0.0D);
        taskVO1.setSelectCacheKeyVo(new SelectCacheKeyVo());
        SysStorePo storePo = new SysStorePo();
        storePo.setSysStoreId(0L);
        storePo.setSysCompanyId(0L);
        storePo.setSysBrandId(0L);
        storePo.setSlaveSysBrandId("");
        storePo.setSysStoreOnlineCode("");
        storePo.setSysStoreOfflineCode("");
        storePo.setStoreId("");
        storePo.setStoreName("");
        storePo.setStorePhone("");
        storePo.setProvinceName("");
        storePo.setCityName("");
        storePo.setAreaName("");
        storePo.setDetailedAddress("");
        storePo.setBizArea("");
        storePo.setLng("");
        storePo.setLat("");
        storePo.setStoreImgs("");
        storePo.setStoreOrcode("");
        storePo.setStoreOrcodeRouteUrl("");
        storePo.setDistributorName("");
        storePo.setStoreType(0);
        storePo.setDictionaryCode("");
        storePo.setShopOwner("");
        storePo.setStoreInfo("");
        storePo.setStatus(false);
        storePo.setOnDate(new Date());
        storePo.setOffDate(new Date());
        storePo.setRemark("");
        storePo.setCreateUserId(0L);
        storePo.setCreateUserName("");
        storePo.setCreateDate(new Date());
        storePo.setModifiedUserId(0L);
        storePo.setModifiedUserName("");
        storePo.setModifiedDate(new Date());
        storePo.setValid(false);
        storePo.setStaffState(false);
        storePo.setSmartStoreCode("");
        storePo.setSmartStoreName("");
        storePo.setIsDisplay(false);
        storePo.setStoreBusinessTime("");
        storePo.setModelType(0);
        storePo.setBusinessStatus(0);
        storePo.setStoreSize(new BigDecimal("0"));
        storePo.setSlaveStoreOrcode("");
        storePo.setSlaveStoreOrcodeRouteUrl("");
        storePo.setOfflineOrgCode("");
        storePo.setDisplay(false);
        storePo.setRechargeAppletCode("");
        storePo.setAppletCodeStatus(0);
        storePo.setQywxDepartmentId(0L);
        storePo.setUseGiftCardStatus((byte)0);
        storePo.setWmStoreId(0L);
        storePo.setAbleOfWashing(false);
        storePo.setStoreWxqySwitch(false);
        storePo.setContactsStaffId(0L);
        storePo.setContactsStaffCode("");

        taskVO1.setStoreList(Lists.newArrayList(storePo));
        taskVO1.setShareName("");
        taskVO1.setMktTaskId(0L);
        taskVO1.setSysCompanyId(0L);
        taskVO1.setSysBrandId(0L);
        taskVO1.setMktGiftBagId(0L);
        taskVO1.setTaskCode("");
        taskVO1.setTaskType(0);
        taskVO1.setTaskName("");
        taskVO1.setStartTime(new Date());
        taskVO1.setEndTime(new Date());
        taskVO1.setTaskInfoType(0);
        taskVO1.setPoints(0);
        taskVO1.setCheckStatus(0);
        taskVO1.setTaskStatus(0);
        taskVO1.setMbrConditionType(0);
        taskVO1.setMbrCondition("");
        taskVO1.setRemark("");
        taskVO1.setCreateUserId(0L);
        taskVO1.setCreateUserName("");
        taskVO1.setCreateDate(new Date());
        taskVO1.setModifiedUserId(0L);
        taskVO1.setModifiedUserName("");
        taskVO1.setModifiedDate(new Date());
        taskVO1.setValid(false);
        taskVO1.setShareTitle("");
        taskVO1.setShareImg("");
        taskVO1.setOrganizationCode("");
        taskVO1.setGrowthNum(0);
        taskVO1.setDetailShowType(0);
        taskVO1.setBizCouponList("");
        taskVO1.setBizGiftBagCouponList("");
        taskVO1.setBizGiftBagPoints(0);
        taskVO1.setBizGiftBagName("");
        taskVO1.setNewMktcenter(false);
        taskVO1.setBizCouponListNewMember("");
        taskVO1.setBizGiftBagCouponListNewMember("");
        taskVO1.setBizGiftBagPointsNewMember(0);
        taskVO1.setBizGiftBagNameNewMember("");
        taskVO1.setBizCouponListInviteOrder("");
        taskVO1.setBizGiftBagCouponListInviteOrder("");
        taskVO1.setBizGiftBagPointsInviteOrder(0);
        taskVO1.setBizGiftBagNameInviteOrder("");
        taskInfoVO.setTaskVO(taskVO1);
        MktGiftBagVO vo = new MktGiftBagVO();
        vo.setCouponDefinitionIdList(Lists.newArrayList(672L,78765L));
        vo.setMktGiftBagId(1L);
        vo.setMktGiftBagCode("2222");
        vo.setMktGiftBagName("3333rrr");
        vo.setPoints(99);
        taskInfoVO.setMktCouponDefinitionList(Lists.newArrayList(222L,7878L));
        taskInfoVO.setMktInviteeCouponDefinitionList(Lists.newArrayList(292L,78L));
        taskInfoVO.setMktInviteOrderCouponDefinitionList(Lists.newArrayList(8989L,453L));
        taskInfoVO.setMbrGroupModel(null);
        taskInfoVO.setMktGiftBag(vo);
        taskInfoVO.setMktInviteGiftBag(vo);
        taskInfoVO.setMktInviteOrderGiftBag(vo);

        System.out.println(JSON.toJSONString(taskInfoVO));

    }
}
