package com.bizvane.mktcenterservice.models.bo;

import com.bizvane.couponfacade.models.vo.SendCouponBatchRequestVO;
import com.bizvane.couponfacade.models.vo.SendCouponSimpleRequestVO;
import com.bizvane.members.facade.service.card.request.IntegralChangeRequestModel;
import com.bizvane.messagefacade.models.vo.*;
import lombok.Data;

/**
 * @author chen.li
 * @date on 2018/8/3 15:10
 * @description
 * @Copyright (c) 2018 上海商帆信息科技有限公司-版权所有
 */
@Data
public class AwardBO {

    /**
     * 业务单id
     */
    private Long businessId;

    /**
     * 业务单编号
     */
    private Long businessCode;

    /**
     * 营销方式 1优惠券营销，2积分营销，3短信营销，4微信模板消息营销
     */
    private Integer mktType;

    /**
     * 线上运营组织（事业部）
     */
    private String orgCode;
    /**
     * 单发券
     */
    private SendCouponSimpleRequestVO sendCouponSimpleRequestVO;

    /**
     * 群发券
     */
    private SendCouponBatchRequestVO sendCouponBatchRequestVO;

    /**
     * 积分奖励对象
     */
    private IntegralChangeRequestModel integralRecordModel;

    /**
     * 模板消息对象
     */
    private MemberMessageVO memberMessageVO;

    /**
     * 短信
     */
    private SysSmsConfigVO sysSmsConfigVO;
    /**
     * 批量短信
     */
    private GenrealSendMessageVO genrealSendMessageVO;
    /**
     * 查询短信数量
     */
    private GenrealGetMessageVO  genrealGetMessageVO;
    /**
     * 发送微信短信消息模板类
     */
    private ActivityMessageVO activityMessageVO;

    /**
     * 是否异步
     */
    private Boolean asyncSend;
}
